About half of all bird nests don't survive due to predators, particularly in fragmented forest areas, but why? University of Illinois researchers monitored both the prey and predator to find an answer.
"Rat snakes accounted for a high percentage of cases of nest predation," said U of I researcher Patrick Weatherhead. "Our hypothesis was that because snakes spend so much more time on the edges of the forest, that's where bird nests should be most vulnerable. And in fact, we never found that." He explained that rat snakes, which in eastern North America are the number one predator to nesting birds, go into the forest to feed, then return to the edges to regulate their body temperature, breed, and shed their skin. "Clearly, a lot of the time they are on the edges they're not actively hunting, because nests on the edges were not at greater risk from the snakes than the nests on the interior of the forest."
Weatherhead said this knowledge of habitat preferences of rat snakes is starting to explain why forest fragmentation usually results in increased nest predation for forest birds.
Fragmented forested areas provide more perimeters, which are beneficial to the snakes. "Snakes really like that interface between the open and closed habitat, whether it's an edge where the forest opens onto a wetland or a rock outcrop or a manmade habitat such as a hay field. So, if your priority is to conserve the birds, you'll want to preserve unfragmented forest habitat," Weatherhead said.. They've been called ecological traps.
Weatherhead says the message is, if you're going to clear land for agriculture or other development, try to avoid breaking the forest into bits and pieces. He concedes that in southern Illinois the land doesn't lend itself to this kind of clearance. "Most of the good agricultural land occurs in the valley bottoms, whereas on the slopes it's too rocky and too steep to make it practical to use for agriculture."
The study, conducted in southern Illinois, used data from radio transmitters implanted in rat snakes combined with information from over 300 bird nests that were located and their fate tracked. Independently, a number of nests that weren't actually a part of the study were monitored with video cameras to document the nest predators.
Rat snakes are common in eastern North America from Texas in the west to the Florida Keys in the east and all the way up to southern Ontario. "Everywhere there have been camera studies, as long as it's in wooded or semi-wooded habitat, rat snakes emerge as the single most important predator. They're common throughout the range, and they're really good at finding bird nests," Weatherhead said.
The miniature video cameras make identification of nest predators possible because they can record activity at the nests around the clock.
How do snakes on the ground see nests up in trees?
Weatherhead says the evidence is circumstantial. "Snake predation is much higher on nests where the young are being fed than when the eggs are being incubated. There's a lot more parental activity when the young are being fed than when the eggs are being incubated. The limited evidence available all seems to point to the snakes observing the parents flying back and forth to the same place, an indicator to the snake that there's a nest there. There are anecdotes of people watching a nest and noticing a rat snake watching that same nest, and from the snake's head movements it was obviously tracking the movement of the adult pairs back and forth." In one case, the snake was then observed going to the nest and eating the young.
Rat snakes get their name because they are primarily predators of small mammals. "But rat snakes are very opportunistic," Weatherhead said. "I have a picture of a rat snake eating a full-grown squirrel. So that's a mouthful. They're generalists both in terms of the mammals they eat and in terms of the birds that they prey on. They'll take whatever birds they encounter, and because they're such good climbers, they can get to both low nests and high nests. They can climb just about any kind of tree. They eat bird eggs, fledglings and sometimes they'll even get the mom if she's sitting on the eggs," Weatherhead said.
Animals such as hawks, raccoons, badgers, foxes and coyotes prey on rat snakes.
Explore further:
Amphibian chytrid fungus reaches Madagascar
More information: Linking snake behavior to nest predation in a Midwestern bird community was published in a 2010 issue of Ecological Applications.
Please sign in to add a comment. Registration is free, and takes less than a minute. Read moreClick here to reset your password.
Sign in to get notified via email when new comments are made.