Many players face a devastating choice: Should you serve with lots of spin, with the serve going long and allowing the opponent to loop, or should you sacrifice spin, even serving with no spin, so you can keep the serve short? Actually, you can do both. In fact, the spinnier the serve, the easier it is to keep short.
Nearly every coach will tell you to first learn to serve with great spin. Holding back on the spin so you can serve short is a good way to develop a bad habit. When you can get great spin on the ball, then you learn to serve short - but this happens automatically. To get maximum spin, you need to whip the racket into the ball at full speed (using the arm to get the playing hand moving, and snapping the wrist into the ball just before contact) but barely graze the ball. Nearly all of the energy from your arm and wrist goes into spin. When that happens, the ball barely comes off the racket - and so it is easy to keep the ball short. Those who have difficulty serving short with spin are having trouble mostly because they are not grazing the ball finely enough - and so the solution isn't to serve with less spin; it's to serve with more spin by grazing the ball more.
The other reason a spinny serve might go long is the contact point is too high, which also leads to the serve being too high. Once you are grazing the ball very finely, you need to learn to serve it low with a low contact point, and learn where to bounce it on each side of the table for varying depths. If you barely graze the ball, you'll not only maximize the spin but since nearly all your energy is going into spin, you'll find yourself almost struggling to get the ball to reach and go over the net - which is a good thing. It means the serve will be short and spinny.
The ideal spin serve will, if given the chance, bounce twice on the opponent's side of the table, with the second bounce as close to the endline as possible. Sometimes a super-short serve is effective (which might bounce three or more times on the opponent's side, given the chance), as it forces the opponent to reach well over the table, but super-short serves are also easier to flip, push short, or quick-push at an angle. Many players use "tweeny" serves, where the second bounce is right around the endline, and the receiver is never quite sure if it will come off the end or not.
Once you have a true spin serve that you can serve short, that's when I'd recommend adding no-spin serves as a variation, and focusing on keeping this and the spin serves very low, with the second bounce near the endline. Serving no-spin when there's little threat of spin isn't as effective after the first few times. No-spin becomes far more effective when it can be done with a spin motion, when there's a threat of spin. (How do you serve no-spin with a spin motion? Several ways, but primarily by contacting the ball near the handle, where the racket travels slowly even in a vigorous serve.) A no-spin serve with a vigorous motion is called "heavy no-spin." Seriously!
It's easier to serve short backspin or no-spin than to serve short sidespin or topspin, or various combinations of these two. So many players fall into the habit of serving just backspin or no-spin when they want to serve short. This greatly limits their options, and makes things a lot easier for the opponent. Well-disguised backspin and no-spin serves are effective, but they are often even more effective if you can throw sidespin and topspin serves into the mix.
At the beginning/intermediate level, I recommend a player who has difficulty serving short with spin to add a simple short backspin serve, with the focus on keeping the ball low with as much backspin as possible while still keeping the ball short. This simple backspin serve should be a temporary serve, used only so the player doesn't spend all his time serve & blocking. (Also, since most players will push it back long, you get to practice your serve and loop a lot.) Roughly speaking, by the time a player is 1800, a well-coached player should be able to serve with good spin and keep it short. By the time he's 2000, he should have varied spin serves that go short. By the time he's 2200 he should have varied and deceptive serves that go short. (He should also be able to do all this with long serves.)
But you don't have to wait until you're 1800, or 2000, or 2200 to do these things. There are many examples of players who really worked at their serves early on (both short and long), and were able to compete with "stronger" players because of this - and because of that stronger competition, they improved faster. Why not you?