The performance begins like this: Erica Siskind, librarian at Oakland (Calif.) Public Library, rides her bike to the front of the room, parks it, and pulls from her basket two sticks and a small wooden box.
Clack, clack!
Siskind hits the sticks together, sets them down, and opens the flaps on the front of the box to create a small stage showing the illustrated cover of that day’s kamishibai storytime.. One by one, the storyteller pulls each card from the top of the box—either slowly to build suspense or quickly to make the audience gasp. Text on the back of the cards can help the storyteller along.
“Once you have that little stage, when you put that in front of the kids, they think it’s like a puppet show, like something fabulous,” Siskind says.
The form has become popular in libraries for its flexibility and accessibility, says storyteller and artist Tara M. McGowan, author of The Kamishibai Classroom: Engaging Multiple Literacies through the Art of Paper Theatre. McGowan says library workers are particularly receptive to trying kamishibai storytimes because paper theater works well with existing programming. Some purchase the theater sets and cards, while others make their own out of cardboard and paper. “It’s keeping the art form alive and [growing] it,” she adds.
During the pandemic, many librarians have uploaded and streamed videos of their storytimes online. Keiko Skow, youth services librarian at Racine (Wis.) Public Library (RPL), posted a new kamishibai storytime every Friday last fall. “Virtual storytelling is quite new to me,” she says. “But slowly, I got used to it.”
Kamishibai flourished in Japan in the 1930s and 1940s, offering storytellers and artists an easy way to make money during a period of economic depression, according to the website Kamishibai for Kids. During World War II, kamishibai storytellers traveled through neighborhoods and bomb shelters to offer entertainment to all ages. The rise of television in the 1950s pushed kamishibai aside, McGowan says, but historians, schools, librarians, publishers, and storytellers are working to keep it alive.
“I grew up in a kamishibai storytelling world,” says Skow, who was born in Japan. She wanted to bring the art form to RPL to teach patrons about other cultures.
‘Another world’
Siskind compares the audience’s experience of kamishibai with the entertainment they would get from watching television. “The difference here is that you can touch it,” she says. “There’s a live person talking to you. But it has the same capacity to take you to another place—a window into another world.”
Kamishibai creates a triangle of emotional connection between the storyteller, the audience, and the world of the story, McGowan says. Creating that connection virtually is a challenge, she adds, but when it works, it’s powerful. “Even if there’s text on the back of the card, the audience doesn’t see it,” she says. “The storyteller is bringing it to life. If you use the stage, that accentuates even more the way you can manipulate the cards in ways that aren’t possible with picture books.”
From bamboo sticks to tin canisters that imitate thunder, many instruments can convey atmosphere and tone in Japanese folktales. But Skow says the most effective tool is her voice. “Happy, sad, low, high,” she says. “I’m not just reading the stories. My voice is actually alive.”
Getting started
Lisa Leuck, director of Elgin (Iowa) Public Library, says kamishibai has helped broaden her town’s horizons. Leuck’s library serves a remote town of about 700 people. “We’re extremely rural and isolated here, not just during the pandemic, but all the time,” she says.
One of Leuck’s goals at the library is to offer patrons experiences they can’t easily get in town. When she discovered kamishibai, she used grant money to purchase a theater and some cards from kamishibai publisher Leaf Moon Arts.
As libraries continue to experiment with virtual programming, McGowan recommends implementing kamishibai storytimes through the pandemic and beyond. “Libraries play a crucial role where children can create kamishibai themselves, and the art form can grow as a culture in the US,” she says.
Siskind, who has collected around 24 different story sets, calls the kamishibai box an investment with solid returns. “The stage is important because that’s what makes it different from a book,” she says. “It’s sturdy, [so] you can use it over and over, share it with a group of librarians, and make your own stories.”
When diving into a historic form of storytelling like kamishibai, librarians recommend an open mind, a respectful attitude, and a willingness to learn and teach others. “When you are choosing which stories to buy, use the same thoughtfulness in respecting the authentic representations of [Japanese] culture.”