For United States and Canada
+1 844.462.6797
ANSYS BLOG
December 28, 2020
As more industries embrace the efficiency, business opportunities and cost reduction inherent to the internet of things (IoT), battery life and latency challenges have come to the forefront. SPARK Microsystems is addressing these challenges with an ultra-wideband (UWB) technology it is developing using Ansys software via the Ansys Startup Program.
The company’s SR1000 series of low-power UWB wireless transceiver ICs is enabling a new class of short-range wireless connectivity applications that would previously have needed to be wired due to power and latency requirements. The SR1000 transceiver series offers an extremely low latency, symmetrical, bi-directional data link coupled with ultralow power consumption and provides a high quality of service to support an uninterrupted low power and low latency data stream.
“Wireless transceivers are a key component of IoT devices,” says Mohammad Rahmani, RF and antenna designer at SPARK Microsystems. “They can be used with different sensors in an area to interconnect a wide range of devices.”
As they make those connections, traditional wireless technologies such as Bluetooth can experience latency, and of course need to be powered. For some applications, those challenges aren’t critical. A small delay in communications may be annoying when using a wireless headset, for instance, and it’s inconvenient to charge the headset’s battery. In many industrial and medical applications, however, milliseconds count and charging or replacing large numbers of sensor batteries quickly gets expensive.
“We want to solve this through an ultra-wideband technology,” says Rahmani. “In contrast to Bluetooth, which is narrowband, we use UWB, which spreads the signal over a very large bandwidth, enabling very short-duration frames, translating into low latency. UWB antennas are yet to be commonplace in the antenna ecosystem. This is where Ansys helped us. Conventional antennas are narrowband, so we needed to design our own systems of passive components and antennas for our UWB transceivers.”
SPARK Microsystems accessed Ansys HFSS via the Ansys Startup Program, which provides software discounts to eligible startups. The company began using HFSS for passive component designs, transmission lines, passive filters, baluns and different types of ultra-wideband antennas. They also use HFSS to check their IC designs within the chip.
Simulated radiation pattern of the UWB differential antenna (left)
and diversity antenna (right) with the presence of the motherboard
“We check absorption loss, impedance matching, radiation pattern predictions, bandwidth, efficiency, gain, polarization — compatibility of the whole system,” says Rahmani. “If we send a signal to the chip, we simulate what happens on the way. HFSS is used on a daily basis to simulate our designs.”
The company’s workflow starts from research presented in books and papers that is used as a basis for the design in HFSS. Those antennas are often too big, so the engineers use HFSS to design smaller antennas. When the antenna is designed, they assemble the components and board. Using simulation to predict how the antenna system will behave in the presence of the other components, SPARK Microsystems engineers optimize and fine-tune them based on specific bandwidth and absorption loss goals. The engineers use parameterization analysis and optimization software to virtually test different structures.
“Ansys HFSS is a crucial tool in our UWB hardware development process,” Rahmani says. “The simulation drives the cost-effective design of our highly sophisticated antennas and passive components, customizing them to range, bandwidth, radiation pattern and efficiency performance requirements. HFSS is also instrumental for performing in-depth analyses of our hardware’s radiated power output. This helps our talented engineering team comply with strict FCC and ETSI standards for UWB emission bands.”
Learn more about the Ansys Startup Program.
We’re here to answer your questions and look forward to speaking with you. A member of our Ansys sales team will contact you shortly.