This sponsored post is produced by Emma Tzeng, social marketing specialist, at Gigya.
Marketers continued to hone their social strategies and experiment with big data and omni-channel tactics in 2013. But this coming year will pose its own hurdles as businesses concentrate their efforts on unifying user experiences, achieving provable social ROI, and knowing their customers in even deeper, more actionable ways.
This article dissects three major challenges marketers will come head to head with this year, along with action plans for tackling and overcoming these obstacles.
Challenge #1: unifying cross-channel experiences with first-party data
In 2013, eMarketer reported that 45 percent of consumers prefer shopping experiences that combine online, mobile, and in-store interactions. As customers interact more with brands across multiple devices, however, marketers need to figure out how to obtain a consistent view of consumer identity over a variety of media.
To complicate the matter, traditional retargeting techniques that use third-party cookie data to construct inferred consumer personas don’t translate to mobile. As the average time spent on mobile devices exceeds desktop usage rates and consumers become increasingly social both online and offline, marketers are more pressed than ever to rely on first-party data to inform their marketing strategies and craft unique customer experiences.
Solution: social login for access to first-party data
The best way to acquire firsthand insights on your users is to start at the source — their social networks. Social networks like Facebook, Twitter, and Google+ collect millions of actionable data points on their users such as their locations, emails, genders, interests, likes, social graphs, and more. Businesses can gain direct access to these insights by leveraging social login on their digital properties, which captures social profile information in a permission-based manner.
For example, Dutch airline KLM incorporates social login into its digital experience, offering four different social provider options and displaying a prominent call to action for a streamlined user experience that encourages more consumers to log in socially. As these users choose social login, KLM gets access to valuable social profile information that it can use to personalize user experiences across channels.
In KLM’s instance, the airline uses social login to power its Meet & Seat program, which lets flyers see who else is on board their flight and select seats based on other flyers’ seat assignments.
By integrating social into its in-flight experiences, KLM gathers valuable data on its customers while facilitating serendipitous, memorable opportunities for their flyers to connect with one another offline.
Challenge #2: proving the ROI of social
As we discussed earlier, social login is the gateway to firsthand consumer insights. These insights, in turn, can be analyzed and measured to determine just how much direct value social delivers to your marketing initiatives.
Solution: measurable insights offer a deeper dive into ROI
We’ve outlined three factors to measure to effectively determine the ROI of your social marketing efforts:
- Increase in registrations – How much have site registration numbers increased since implementing social login?
- Value of a registered user – To determine the value of a registered user, you’ll want to examine the estimated return for new user registrations. Take the following example: An ecommerce site registers 10,000 users a month. Of these registrations, 500 users go on to make purchases on the site over the span of a year. If each purchaser’s average shopping cart conversion is $75, then the value per registered user is $3.75. What is the value per registered user for your business?
- Decrease in forgotten password help desk issues – When users log in socially, they save themselves from having to remember another username and password combination. Your business, in turn, avoids the hassle of dealing with lost password recovery issues. What is the decrease in support costs since implementing social login?
Check out our white paper, Path to ROI: Boosting Demand Gen and Improving Conversions with Social Login, for a deeper dive into how capturing social identities directly affects ROI.
Challenge #3: knowing your customers in even deeper, more actionable ways
As users’ Internet habits evolve, we’re seeing a greater shift in online sharing: consumers are posting personal photographs, life events, and more across their social networks. This move towards a more connected, open social web reflects how consumers and businesses should interact in a landscape that encourages the sharing of users’ information in a safe, valuable way.
Solution: schemaless, socially optimized database for seamless data storage
To help this process along, you should invest in a database that is not only secure but also fully equipped to handle the varied, dynamic nature of social data. This database structure is known as a schemaless database, and it enables sites and apps to store all types of unstructured (social and behavioral) data without any constraints.
After finding a secure data management system to store and manage your users’ data, you’ll want to invest in a marketer-friendly, web-based dashboard that enables marketers to access user data, define their audience segments, and apply these findings directly to their marketing strategies. This grants you full control over your marketing efforts, allowing you to work with the data to glean new insights on your user base and turn these insights into measurable actions.
In 2014, personalization triumphs
As consumers continue gravitating towards personal online experiences, it’s important for businesses wanting to retain a loyal customer base to remain a step ahead of their users. This means swapping mass marketing techniques for tailored messages that speak to users on an individual level. Businesses that successfully carry this out can expect to see real ROI on their marketing.