Our latest research, presented in the The New Key Opinion Leader is Here report — written in partnership with Tony Wang and with data from TD Reply — evaluates how a new generation of Chinese Key Opinion Leaders (KOLs) are growing up on a different set of platforms and changing the rules of influencer marketing. We call them Cultural Opinion Leaders (COLs). Driven by Gen Z culture, COLs will set the tone going forward for how brands navigate influence in China and beyond. Here, we’re sharing an exclusive look at some of the insights retrieved from a series of conducted interviews with prominent experts on how influence is created, and shifting, in the Chinese market.
While Millennials in China represent the largest annual spend per capita on luxury goods at ¥41,000 RMB compared to Gen Z’s ¥25,000 RMB (or $6,350 vs $3,870), Gen Z consumers are already on par with their Gen X counterparts, and they’re only getting started. The majority of Gen Z consumers in China have only started purchasing luxury fashion in the past year.
This makes understanding what exactly drives influence among Chinese Gen Z luxury consumers increasingly imperative for brands. And as far as the influencer economy goes, the next generation of KOLs will reflect the shifting values of China’s Gen Z consumer.
What’s certain is that, for them, Chinese culture is part of global culture. They’re less interested in showing an aspirational and manicured representation of their lifestyle, and are more driven by fostering community around specific topics, niches, and aesthetics that interest them.
To better get a broader sense of the cultural zeitgeist for China’s Gen Z fashion and streetwear consumers, we spoke with Edison Chen about the role China’s youth will play in catalyzing the country’s cultural scene forward. Chen is a Canadian-born Hong Kong actor, singer, rapper, fashion designer, and entrepreneur, as well as the founder and creative director of CLOT, a streetwear and fashion label, and founder of multi-brand store JUICE.
Here, Chen talks about how Chinese Gen Z creatives will increasingly become an important contributor to global street culture, the rise of the creative scene in some of China’s biggest cities, and his expansion plans for CLOT in the country.
Tony Wang: Edison, tell us more about your expansion plans in China for CLOT.
Edison Chen: I’m interested in finding the next generation of young Chinese designers and creators. Creatives who I can collaborate with and nurture, and create products with an actual purpose that are culturally relevant. Because China has been more open during the pandemic last year, CLOT and JUICE have taken off in a really good way. We’re trying to break even further into the Chinese market and do more collaborations locally.
What are the key cities that you want to break into, in order to grow?
We’re already in Tier 1 cities, so when we looked at the expansion plans for CLOT and our other creative projects, we found ourselves increasingly attracted to cities like Shenzhen, Xi’an Chengdu, Guangzong, and beyond. The next wave of culture is going to be interesting and we want to be in the creative hubs of tomorrow. While they might supposedly be less developed, it’s out of the lack of resources that will create the greatest boost in creativity. Like the rose that grew from concrete, I think these locations are where on-the-ground local culture will be strongest and we’ll find future talent to nurture and help support.
Have you noticed any cultural shifts in the country for a younger generation?
The narrative is changing, and I’ve seen this really accelerate in the past 18 months. People are starting to believe in themselves, that they can influence culture on an international level. There’s a new wave of cultural KOLs in the country – everyone before was just following trends and they become KOLs because they can parrot it back. But new KOLs are going to be doing dope shit, and [just] not be influential because they have dope shit.
Even on the streets, people are starting to dress in non-traditional but also personalized ways. It reminds me of the energy you found – and still find — in Japan when it comes to street style.
What are some key differences between influencers in the West and KOLs in China?
Western influencers are recognized for their perspective, whereas traditional KOLs in China are recognized for their following. But I believe the next generation of KOLs in China are going to create culture — combining domestic and international references online and then translating it into something of their own making.
It’s now finally coming back to the community and building it. While there are very few street crews in China, I believe that will change in the coming years, with youth being more open to collaborating and energizing each other. You just gotta find the real motherfuckers. Lots of KOLs are chosen by agencies and incubators; their influence isn’t really earned. Sure, you can sign boy bands time and time again and churn them out, but that’s not sustainable for the scene.
So what makes new Cultural Opinion Leaders (COLs) credible is that they’ll contribute to global culture?
Yes, entirely. China used to look towards and copy Western culture, but now that’s changing. Younger creatives are understanding they have an important voice for the future and have to believe in themselves. We have to kick down these doors and let them have that voice.
Of course, in China, there are a lot of sensitive topics. So when it comes to culture, it’s this game where you have to know the rules, and then you have to get creative around them. For example, I did a Jordan project around the Terracotta warriors. There was some cultural sensitivity around a Western brand turning a national treasure into a product, so we had to be very mindful during the process. In Western media you can be more flippant and irreverent, but in China you’ll get banned if you’re not sensitive to these kinds of cultural matters.
Within the next decade or two, you’ll see a lot of global music, cinema, and art come from China. This to me is part of China’s natural cultural progression, from an import to an export country. People are starting to care (both domestically and internationally) about what Chinese people are thinking and their point of view on culture.
For access to the complete report and to enroll in a 10-day email series breaking down key findings, sign up here.