.
- System Center Virtual Application Server—Streams SoftGrid-enabled applications to clients and verifies whether a client is authorized for an application.
- SoftGrid Data Store—Stores information about the SoftGrid environment.
- SoftGrid Management Web Service— The interface between the SoftGrid Management Console and the SoftGrid Data Store. Uses Microsoft .NET Framework 1.1 or later and requires Microsoft IIS 5.0 or later with ASP .NET extensions enabled.
- SoftGrid Client—A locally installed service running on a user's machine that communicates with the virtual application server to receive the streamed application and cache it for use even when the client isn't connected to the network. The client also contains the SystemGuard environment for runtime virtualized application execution.
- SoftGrid Sequencer—A wizard-based tool that's used to create a streamable application from the original application media. This process will be familiar to users of software such as WinINSTALL, which creates a .msi file based on installing an application. The sequencing of an application actually consists of three phases: the package configuration, which is an information gathering stage; the application installation, during which the wizard monitors the OS for changes the application makes during installation, including file-system changes, component registration, and registry changes; and the actual launching of the application, which is important because on first use SoftGrid prioritizes the data to stream to the client based on what is first used when the application starts (known as Feature Block 1—FB1—of the stream) rather than waiting for the entire stream to send before the application can start.
Additional components are available that integrate with Microsoft's System Center Configuration Manager (SCCM) solution to let you use SCCM for distribution. In addition, a separate client is designed for terminal server–type environments (including Citrix). Although I don't have space to discuss these components, you should be aware of them in case you use SCCM or terminal servers in your environment.
Installation and
Configuration
The first step in using SoftGrid is to install the System Center Virtual Application Server component, which has reasonable software and hardware requirements. A data store is required for storing information such as application usage, licensing, and server configuration. The data store can be hosted on SQL Server 2005 or SQL Server 2000, as well as on Microsoft SQL Server Desktop Engine (MSDE) in test environments. The data store doesn't need to be on the same server as the application, although it should be on the same local network.
A directory service such as Active Directory (AD) is also required for the SoftGrid suite to function. A Windows NT 4.0 domain is sufficient, but I'd be surprised if someone were forward thinking enough to use application virtualization but were still running NT 4.0. During installation, you must specify an account with read access to the directory service. You also need two global groups to identify SoftGrid administrators and users who can use SoftGrid's services. If all users in the domain need access to SoftGrid, you can add the Domain Users group to this global group.
You can install SoftGrid on Windows Server 2003 or Windows 2000 Server. The SoftGrid Management Console runs on Windows 2003 or Windows XP and requires .NET Framework 1.1 and Microsoft Management Console (MMC) 3.0, which is included in Windows 2003 R2 and can be downloaded from Microsoft for other OS platforms.
The SoftGrid System Center Virtual Application Server component requires a Pentium III 1GHz processor, at least 512MB of memory, and 200MB of disk space. The more applications you virtualize, the more disk space you'll need. You can use the Windows load-balancing functionality or hardware load balancers to install and balance multiple SoftGrid Virtual Application Server machines.
To protect the data store, don't use MSDE in a production environment. MSDE has limited recoverability and replication capabilities, as well as limited management options. If you're running multiple SoftGrid servers in an environment that requires high availability, use SQL Server and Windows clustering services to remove any single points of failure.
SoftGrid's documentation includes detailed installation instructions. Be sure that you've read and met the prerequisites of creating an AD account and groups for SoftGrid to use, as Figure 3 shows. To reduce administrative overhead, you can set the AD account password to never expire. However, doing so might cause security problems. Establish a routine for regularly changing the password. Then, you can use the SoftGrid Management Console's Account Authority property settings to easily update the password, as Figure 4 shows.
During installation, you're prompted for various pieces of information, including the following:
- Components to install (you can have a distributed environment with various server components spread over multiple servers)
- Whether to use SQL Server or MSDE (you need to specify the database server if you use SQL Server; MSDE is installed by default)
- AD account to use, including the permission groups you created
- The path to use for storing application content (which by default is C:\Program Files Softricity\SoftGrid Server\content)
After installation is complete, the SoftGrid Management Console is available in the Administrative Tools program group. On first execution, the Management Console asks for the SoftGrid system to connect to. SoftGrid operates over port 80 and requires the name of the SoftGrid Management Web Service. As I already explained, the Management Console never communicates with the data store directly; all communication occurs through the Management Web Service.
More to Come
Application virtualization is a hot trend. Microsoft's SoftGrid lets you easily virtualize applications without requiring a lot of overhead. In addition, the SystemGuard environment lets applications run simultaneously without encountering any compatibility issues. To test the product, I experimented with virtualizing Microsoft Office XP and Office 2003; I found the process to be very smooth and intuitive. In a subsequent article, I'll explain how to use SoftGrid to virtualize applications.