A clean process.
As part of efforts to contain the global pandemic, demand is higher than ever for professional cleaning equipment that can ensure compliance with necessary hygiene standards—in public spaces, workplaces, restaurants and hotels, and private households.
Cleanliness has been Nilfisk’s leitmotif for 115 years. Founded in Copenhagen, the company has grown from a small manufacturer of vacuum cleaners to a global leader in the professional cleaning industry with over 4,500 employees. The company’s floor cleaning machines, vacuum cleaners, and high-pressure washers for professional users and consumers are now sold in more than 100 countries.
“The pandemic has changed the nature and role of cleaning. Many companies are completely rethinking their concepts, focusing on more stringent procedures, and cleaning and disinfecting more frequently,” explains Morten Jensen, Director of Logistics at Nilfisk. “The demand for corresponding solutions is rising sharply right now. And that calls for an efficient logistics concept.”
Less is more
Years ago, the company had already changed its logistics strategy, reducing the number of its logistics service providers from 30 to six. DACHSER and its comprehensive groupage network have been a part of this since 2010. “Fast, on-time, and transparent delivery throughout Europe is a critical factor for our business,” Jensen says. “With this in mind, we want to make our supply chain as simple as possible.”
In 2020, the global company headquartered in Denmark reviewed its logistics processes. This resulted in a new structure that can offer fast, reliable deliveries to Nilfisk’s markets in Northern and Central Europe, the UK, Russia, and Turkey. The focus is on three centrally controlled distribution centers: in Ghent, Belgium; Trollhättan, Sweden; and Tarragona, Spain. In implementing such a fundamental restructuring, the challenge was to continue to keep transit times to customers throughout Europe as short as possible.
“With our network and our entargo product lines, especially our premium targospeed offering, we can provide Nilfisk with effective support as it turns many small, local units into a powerful whole and as it organizes sales even faster and even more efficiently,” says Jonas Bettray, Key Account Manager European Logistics at DACHSER. “DACHSER’s European network is tailor-made for this bundling of freight services thanks to its exceptional quality and delivery reliability.” He adds that DACHSER is currently linking two of the distribution centers—in Ghent via the DACHSER branch in Mouscron and in Trollhättan via the DACHSER branch in Gothenburg—to its groupage network. From here, all target markets can be reached within a very short time.
“Fast, on-time, and transparent delivery throughout Europe is a critical factor for our business.” Morten Jensen, Director of Logistics at Nilfisk
What Nilfisk most appreciates is DACHSER’s impressive flexibility. “Normally, 12 trucks set off per day from the distribution center in Ghent for consolidation at DACHSER’s Mouscron branch, but at peak times this can rise to 20 trucks. This requires robust and resilient structures,” says Kim Østerby, Transport Development Manager EMEA at Nilfisk. Reliability is a key criterion for the company, he adds. But there is more to it than that: “We want to be able to access all the information and reports we need to achieve our goals—anytime, anywhere in Europe.”
The acid test in difficult times
For Jensen, proximity and trust are essential aspects of the logistics service provider relationship. This is something that Nilfisk particularly appreciated during Brexit and the COVID-19 pandemic, he says, when European goods flows were under considerable pressure. “DACHSER has always acted confidently and reliably even under difficult conditions. It’s especially important to keep the delivery promise in a period of uncertainty and restrictions impacting both our two companies as well as our employees’ ways of working,” Jensen says.
“We’ve grown even closer in these complicated times,” Bettray confirms. “The fact that both partners get on well at the personal level certainly helped.” He particularly appreciates the “Scandinavian” style of togetherness. “We always tackle all tasks and challenges together, in a respectful and direct way. Always as equals and in mutual appreciation. This is an essential part of our success story,” Bettray says.
To make all processes as efficient and transparent as possible, Nilfisk and DACHSER have concluded a headquarters-headquarters agreement. This governs close and personal exchanges at the management level and avoids possible information delays at the local and regional level. “We’ve made logistics a management issue,” Jensen says. “With a structural turnaround like the one we’ve just had, having immediate, direct exchanges at the decision-maker level makes things much easier.”
In the future, there is also “excellent potential for collaboration” in the consumer markets, Bettray adds. Thanks to the established industry solution DACHSER DIY Logistics, existing agreements can be leveraged to make time-sensitive deliveries reliably and punctually to over 18,000 DIY stores throughout Europe. For Jensen, the fact that sustainability is a high priority at DACHSER is another reason for choosing the logistics provider to help Nilfisk get there. “Professional cleaning always aims to improve quality of life. That’s possible only with sustainable solutions—in logistics, too. And on that, we’re on exactly the same wavelength as DACHSER.”