Pap Smear
- What is a Pap Smear and Why is it Performed?
- Who Should Receive a Pap Smear?
- What are the Latest Statistics on Pap Smears and Cervical Cancer?
- What is the Human Papillomavirus (HPV)?
- How Should a Woman Prepare for a Pap Smear?
- How is a Pap Smear Performed?
- Are There Any Risks to a Pap Smear?
- How are Cervical Cells Evaluated?
- How are the Results of a Pap Smear Described?
- What are the Latest Advances with Pap Smear?
- What Can Affect the Results of a Pap Smear?
- What Additional Tests May Be Ordered if the Results of a Pap Smear are Abnormal?
- Additional Resources and References
Cervical cancer screening began in the United States in the late 1940s after Dr. George Papaniclaou developed the Pap smear. A Pap smear (also called a Pap test) is a screening test used to examine cells from the cervix and the vagina. (The cervix is the portion of the uterus that protrudes into the vagina). Cervical and vaginal cells are studied to determine whether there is evidence of cancer or pre-cancerous changes. If abnormal cells are found, they are classified according to their degree of abnormality. Most abnormal Pap smears are caused by cervical infections or inflammation which can usually be successfully treated before leading to cancer.
Abnormal Pap smear findings may indicate:
- Infection (including the human papillomavirus, HPV)
- Swelling or inflammation
- Pre-cancerous cell changes
- Cervical cancer
Pap smear is perceived by the medical community as a reliable screening tool to help detect cervical cancer, along with regular pelvic exams. However, Pap smears cannot typically detect other types of cancers, such as ovarian or uterine cancers, or sexually-transmitted diseases (STD), with the exception of the human papillomavirus (HPV).
The American Cancer Society recommends that all women begin receiving yearly Pap smears and pelvic examinations at age 18 or when they become sexually active, whichever occurs earlier. Some physicians will not perform a Pap smear each year if a woman has had three negative Pap smears in the course of three years. However, a yearly pelvic exam should be continued even if Pap smears are not given each year.
Regular or more frequent Pap smears may be performed on women who have had hysterectomies (surgery to remove the uterus, including the cervix), especially if the hysterectomy was performed because pre-cancerous and cancerous cells were found in the cervix. In women who have had hysterectomies, the tissues of the vagina are analyzed for changes that may indicate cancer.
In addition, women who have a weakened immune system (from AIDS, chemotherapy or drug treatments, or organ transplants) are considered at higher risk for cervical cancer and may require Pap smears more frequently than once a year.
Approximately 50 million Pap smears are performed each year in the United States. The death rate from cervical cancer has declined dramatically since 1955 (74% from 1955 to 1992) largely from the increased use of the Pap smear. When detected early, the five-year survival rate for cervical cancer is approximately 91%. If cervical cancer is detected before it has invaded any surrounding tissues, the five-year survival rate is nearly 100%.
Even with the increased use of the Pap smear, between 60% and 80% of American women who are newly diagnosed with cervical cancer have not had a Pap smear within the last five years, if ever. According to recent studies, elderly, African-American, and low-income women are the least likely to have annual Pap smears.
The American Cancer Society estimates that in 2001, 12,900 new cases of invasive cervical cancer will be diagnosed and approximately 4,400 women will die from the disease. Researchers estimate that non-invasive cervical cancer is nearly four times as likely as invasive cervical cancer.
The human papillomavirus (HPV) is a common sexually transmitted disease that affects both men and women. There are over 80 different strains of HPV, and the most do not pose any health risks. However, some of the strains of HPV cause genital warts in men and women and can cause cellular changes that may lead to cervical cancer in women. A major risk factor for cervical cancer is the HPV. It is estimated that one million new cases of HPV occur each year, and 20% to 40% of sexually active women have HPV.
It is essential that all women over age 18 have annual Pap smears since the test accurately detects approximately 90% of all cervical cancers. HPV is most commonly discovered by abnormal Pap smears results and is most likely to spread when genital warts are visible. HPV does not typically interfere with pregnancy or childbirth.
Research has shown that condoms do not always prevent the spread of HPV because the virus can be transmitted by skin contact of any HPV-infected area (such as the genitals). Limiting the number of sexual partners and not having sexual intercourse with a person who has had several sexual partners can help prevent HPV. There is currently no cure for HPV.
According to the American Cancer Society, removing genital warts and abnormal cell growths caused by HPV can help reduce the risk of cervical cancer from HPV. Treatments to remove genital warts include: laser surgery, convention surgery, cold cautery (freezing the tissue), hot cautery (burning the warts off with an electric instrument), or directly applying podophyllin or trichloroacetic acid. In addition, the U.S. Food and Drug Administration (FDA) has recently approved a drug called imiquimod cream to treat genital and perianal warts.
Women should not schedule a Pap smear while they are menstruating because the presence of blood cells may interfere with the test results. However, if a woman is experiencing abnormal vaginal bleeding, a Pap smear may help determine the cause. Many physicians recommend not using douches, tampons, or vaginal medications for at least 24 to 48 hours prior to having a Pap smear. According to the American Cancer Society, the ideal time for a woman to have a Pap smear is five days after her menstrual period has ended.