Helen Clark: Speech at the High-Level Seminar on Addressing Climate Change in South-South Co-operation
Keynote Speech by UNDP Administrator Helen Clark,
High-Level Seminar on Addressing Climate Change
in South-South Co-operation
COP19, Warsaw, Poland
I am pleased to address this second High-Level Seminar on Addressing Climate Change in South-South Co-operation.
I thank the National Development and Reform Commission of China and Minister Xie Zhenhua for the initiative they have taken in organizing these events, and in guiding China’s work in this area. Their efforts are important in helping to raise awareness of South-South co-operation as a powerful tool in the fight against climate change.
There is no ‘one size fits all’ blueprint for making the transition to low-carbon and climate resilient development. But, without doubt, South-South co-operation is helping countries to shape their own, nationally appropriate paths to sustainable and inclusive development. This includes experience-sharing on how to build resilience to ever more deadly and costly natural disasters and less predictable weather patterns, and on taking integrated approaches to advance economic, social, and environmental objectives simultaneously – what we in UNDP call “triple win” approaches. Through the exchange of low-emission technologies and technical know-how, countries are able to lower the costs of sustainable solutions and strengthen their ability to access and deploy climate finance.
Tackling the shared threat of climate change demands “business unusual”. Business as usual - built on growth models which emerged from the Industrial Revolution of another age - has led to a level of environmental degradation which now threatens the carrying capacity of our planet. If we cannot cap global warming before it exceeds the two degrees Celsius level at which scientists predict there will be catastrophic and irreversible consequences, Hurricane Sandy and Typhoon Haiyan-level storms are likely no longer to be rare events. Such extreme disasters destroy lives and livelihoods and seriously set back the progress communities have made.
United Nations Member Statesagreed at Rio+20 last year that sustained development is not possible without protecting the ecosystems on which life depends. While developed countries have a particular responsibility to cut emissions, advance and disseminate low-carbon technologies, and support mitigation and adaptation, achieving sustainable development demands that all countries act.
South-South co-operation is an increasingly important modality for action. The South has emerged as a significant producer of low-carbon technologies and innovation. As South-South co-operation scales up, more countries will benefit from the impressive examples of low-carbon, climate resilient development found within the Global South, which can deliver new jobs and reduce both poverty and environmental degradation.
In 2012, China’s renewable energy sector employed more than 1.7 million people. These were new jobs which had emerged over the past decade or so. China is establishing national policies to incentivize green growth, setting rigorous targets for energy efficiency and energy conservation, and making significant and growing investments in renewable energy.
In China’s agricultural sectors, we are seeing how erosion control, agro-forestry, and other innovations are enabling productivity increases, ecosystem restoration, and the building of greater resilience to the threat of flooding and drought.
Now China is sharing its experiences through its Climate Change South-South Co-operation training programmes. To date, more than 700 government officials from 42 developing countries have received training on issues related to renewable energy, climate change, and forestry, and there are plans to train another 2,000 over the next two years.[1]
UNDP is pleased to be working with China to distil and disseminate lessons learned from China’s and other countries’ experiences in this area. We are presently working with the Shakti Sustainable Energy Foundation, China’s NDRC, and the Energy and Resources Institute of India (TERI) on a set of studies which analyze various scenarios for low carbon development in India and China, and offer concrete recommendations.
UNDP’s role is that of a knowledge broker, builder of capacities, and facilitator of exchanges. To these tasks, UNDP brings an understanding of what is and is not working around the world in adaptation to and mitigation of climate change. Through our universal presence in developing countries, we see and are involved in a great deal of activity to address climate change.
When Minister Xie and I met in Beijing in September, we acknowledged that, working together, China and UNDP could do a great deal to advance South-South co-operation to address climate change. We agreed to strive to strengthen and formalize our collaboration in an agreement which would bring together China’s expertise, innovations, and experience with UNDP’s expertise, global networks, and on the ground experience.
In this context, UNDP looks forward to working with China as it implements its important pledge made at Rio+20 to support least developed countries, small island developing states, and African countries to address climate change.
There is much good work on which to build. SIDS countries are strengthening their climate resilience, including through a UNDP- facilitated initiative to learn from each other’s disaster reduction and response-related experiences, technologies, and methodologies. China, Ghana, Zambia, and UNDP are in the planning stages of an initiative to facilitate the exchange of clean energy technologies and to build local capacities to deploy and maintain them.
The UNFCCC process opens up a number of opportunities to strengthen South-South co-operation. The Green Climate Fund could, for example, foster South-South co-operation, to speed up “finance readiness”. This is a pressing priority which has been recognized by the GCF Board. A number of countries are now developing their readiness plans, which set out the actions and capacities they need in order to access climate finance and realize their national climate priorities. Through South-South co-operation, countries can learn from the early experiences of others – helping them to lower the costs and improve the process.
South-South and triangular co-operation can then help countries to meet funding criteria, build capacity, and use public funds in catalytic ways which will leverage additional investment. Such efforts, in turn, could help shape the efforts of the Green Climate Fund to lower the transaction costs of accessing monies and make climate finance more accessible to LDCs and SIDS.
Much remains to be done to reach a new climate change agreement in 2015. Concrete decisions and firm commitments are needed here in Warsaw to ensure that the solutions put forward in 2015 are both workable and adequate. 2015 is also the year when UN Member States will make decisions about the global development agenda which follows the MDGs. As climate change has emerged as one of the greatest threats to development, we need both these negotiation processes to succeed. In implementing both a new global development agenda and a new global climate agreement, South-South co-operation will have a vital role to play.
[1]