Edward Fennell
Today The Times announces the launch of our Student Advocacy Competition, to be held jointly with Herbert Smith, the leading City law firm. This is a new development for Times Law and neatly complements our annual Times Law Awards student essay competition run with One Essex Court chambers during the autumn and winter.
How to enter The Times/Herbert Smith advocacy competition and the rules
The idea of the competition — which is open to all students, full or part-time, registered with UK universities or colleges (including schools and colleges of law) — is to provide entrants with the opportunity to develop their advocacy skills on a theme of topical interest to the legal profession.
The challenge for the inaugural competition is the question Diversity in the legal profession: cause for concern or trendy bandwagon?
The statistics are stark. Ian Gatt, QC, a member of Herbert Smith’s advocacy team and chairman of its inclusivity group, says: “Of 1,200 QCs, around 1,120 are white with just 66 from ethnic minority groups; only 116 are women. This does not reflect the composition of the self-employed Bar generally where nearly one in three barristers is a woman and one in ten is from a ethnic minority group.”
The position is similar elsewhere within the senior ranks in the legal profession. “Partners in City law firms, for example, overwhelmingly conform to the white, male stereotype. The senior ranks of the judiciary are also male-dominated with fewer than 10 per cent of High Court judges being women and one ethnic minority judge of the 108 High Court judges. There are no ethnic minority judges in the Court of Appeal or the House of Lords.”
It is not surprising then that Mrs Justice Dobbs, the liaison judge for diversity, said in her lecture Diversity in the Judiciary last October: “Diversity is a hot topic. Diversity in the legal profession and the judiciary is an issue getting warmer by the day.”
Entrants might wish to consider to what degree it matters if the composition of the legal profession — in its upper ranks — does not reflect the society that it serves. Is the quality of justice or the conduct of legal process poorer as a result? Do clients get worse service or are judgments flawed because of the predominant gender and ethnicity of the people who make the key decisions? Or if it does, to what degree is it right to try to correct the imbalance — should change emerge over time as a result of changed patterns of entry to the profession (more than half are woman) — or should urgent and pro-active steps be taken to make the top of the profession more diverse?
Some may argue that the real issue is one of social equity. Are opportunity and privilege skewed in one direction? Perhaps we need to consider diversity more widely: the setting-up of lesbian, gay, bisexual and transgender networks (as at Herbert Smith itself) suggests that much more needs to be done to encourage people of all persuasions to feel more comfortable in the workplace. But perhaps the biggest area of contention is class. After all, how many white working-class boys from deprived areas of the country are recruited to the profession — let alone start to climb to its upper echelons?
So there are complex issues and the reasons of those who defend the status quo and those who deplore it deserve to be put under the microscope. In the first round we invite entrants to develop an outline argument of no more than 400 words that highlights (in bullet-point form if preferred) the key issues you wish to address. The judges will look for originality of thought, clarity of expression and logicality of presentation. To supplement this students are strongly encouraged to submit a video overview of their outline argument. This should last no more than 90 seconds — enough to give the judges a flavour of their advocacy skills.
Based on these entries a shortlist of six candidates will be selected to make a ten-minute presentation at a half- day finalists event to be held on Tuesday, September 16, in the offices of Herbert Smith in London. Those selected will also have the opportunity to hone their skills in advance, at an advocacy workshop, with one of the firm’s experienced advocacy trainers.
Among the high-profile judging team that will take the final decision on the winners is: Shami Chakrabarti, director of Liberty; Ben Summerskill, chief executive of Stonewall; Nigel Savage, chief executive of The College of Law; and Ian Gatt, QC, of Herbert Smith. They will also have the task of questioning candidates on their submissions.
The prizes, to be awarded at a winners’ reception on the evening of the finalists event, are: £3,000 for the winner; £2,000 for the second-placed; £1,000 for third; and three of £500 for each of the runners-up. All those shortlisted will also be invited for interview for a vacation scheme placement at Herbert Smith. The winning entries will be published on Times Law online.
This is an exciting and challenging competition on an important issue to the legal community. We look forward to receiving your.