Senator John Kerry keeps telling us that "the rich" need to pay more in taxes, and he proposes to raise the marginal tax rate that Americans with earnings in the two top tax brackets would pay. But the small amount that Kerry and his wife paid last year in taxes demonstrates the error of this approach. Under Kerry's own plan to "tax the rich," his and his wife's average tax rate would increase to only 15.2 percent, far less than many small-business owners and middle-class earners would pay. This discrepancy is an artifact of today's convoluted tax code. In short, the Kerrys' own tax return makes the case for fundamental tax reform.
The Senator, for Example
Senator Kerry and his wife are among the 400 richest Americans. Last year, they paid only 13.4 percent of their declared $5.5 million income in federal taxes.
Estimates of the Kerrys' worth range from a low of $700 million to a high of $3.2 billion. How much income would you expect a billion dollars to produce? The Kerrys reported $5 million in income, which is a return of only about one-half of 1 percent, which is far lower than the return on even U.S. government securities.
How could this be? Like many wealthy Americans, the Kerrys have at their disposal a variety of legal means to keep income off of their tax returns and to keep the tax rate on their reported income low. Many of these loopholes are the result of tax policies that aim to reward or punish certain behavior with incentives and sanctions.
These policies make the tax code extremely complex, and their interactions and frequent vagueness benefit those with the means to employ extremely sophisticated tax-planning strategies. Conversely, this complexity disadvantages ordinary taxpayers, few of whom have the time or ability to navigate thousands of pages of tax code regulations, up-to-the-minute legal decisions, and administrative explanations and memoranda.
Kerry's running mate, Senator John Edwards, must have the same tax adviser. Last year, Senator and Mrs. Edwards paid an average tax rate of only 5.1 percent on their reported $434,000 of income, or less than one-third of the rate that the average taxpayer pays.
The Senator's Tax Plan
For those concerned about tax equity-that is, that all Americans pay their fair share in taxes-working within the confines of the existing tax system is extremely limiting. Raising marginal rates on the rich, for example, will not necessarily result in the super-rich paying markedly higher rates or even as much, as a percentage of actual income, as middle-class taxpayers.
So, in effect, any proposal to raise the top marginal rate is not really a proposal to increase taxes on those who are already rich, whether through inheritance, hard work, luck, or marriage, but a proposal to increase taxes on those who are trying to become rich. Those who have already achieved wealth, by whatever means, can tax shelter much of their income, but those with little in the way of assets find it almost impossible to shelter their earnings from taxes.
Senator Kerry's tax plan exemplifies this difficulty. Kerry proposes to raise the marginal tax rates that apply to income above $200,000. But what effect would this have on the actual taxes paid by the very wealthy? According to an analysis by the Argus Group, a respected tax law and economics firm, the Kerrys' average tax rate would only increase by 1.8 percentage points to 15.2 percent under the senator's plan. At the same time, many small-business owners would see their average rate rise by 4.0 percentage points, resulting in effective rates as high as 35 to 40 percent, including certain deduction phase-outs.
In other words, by proposing to raise the top marginal rates, Senator Kerry implicitly embraces a system of taxation under which he and his wife and other established, wealthy families pay an average tax rate that is less than half of what many young professionals and small-business owners, many of whom may possess few or no assets, have to pay. This fact should give any tax-equity advocate pause.
The Case for Fundamental Reform
No doubt unintentionally, Senator Kerry makes a strong case for fundamental tax reform, and specifically a flat tax or consumption tax.
Under a flat tax, all Americans, regardless of income level, pay the same percentage of their income in taxes. A flat tax minimizes the complexity of the tax code, eliminating the sort of loopholes that are today so valuable to those who can afford sophisticated tax planning.
Another option for tax reform is the consumption tax, under which savings and investment are excluded from income and only consumption is taxed. Economic efficiency would be enhanced because people would be taxed only on what they take out of the economy rather than on what they put into it.
Municipal bonds, a favorite investment tool of the wealthy, are already treated this way under the tax code, but few other investments are. As a result, most Americans investing their money are doubly taxed: once on their income and again on the investments that they make with that income. Just like the wealthy, all investors should be able to avoid double taxation.
In addition to promoting tax equity, a flat or consumption tax would stimulate an additional supply of labor and capital, which would result in much higher economic growth and lower unemployment to the benefit of all Americans.
As Senator Kerry's own experience so aptly demonstrates, today's tax code advantages the wealthy at the expense of those trying to better their lots. And as his proposal to raise taxes on the rich demonstrates, working within the confines of today's tax code is no way to fix the problem. Only a flat rate, whether under a flat income tax or a consumption tax, would ensure that all taxpayers-even the wealthy and even Senator and Mrs. Kerry-pay their fair share.
Richard W. Rahn is a Visiting Fellow at The Heritage Foundation.