Unfortunately, credit unions, banks and other financial institutions know all too well the potential effects distributed denial of service, or DDoS, attacks can have on information technology systems and websites. However, over the last year, credit unions, banks and other financial institutions have increasingly seen similar DDoS-style attacks that have left Automated Clearing House systems nearly incapacitated by massive amounts of fraudulent transactions.
These attacks on the payments system are part of a concerted fraud scheme based on conspiracy theories found on social media and member-only blogs and chatrooms across the internet. Although these theories are easily refutable, it is important to know their basic premise: Several groups or individuals believe there is property or money being held in a trust that was set up at birth for every citizen by the U.S. government. All the supposed owner needs to do to access these funds through the payments system is to use the Federal Reserve Systems’ routing numbers and the owner’s social security number as the account number.
Instructions for carrying out this fraud are readily available online and on social media posts and videos. The scheme is referenced online in a number of ways, including U.S. Treasury Direct Accounts, Strawman Accounts, Lesser Accounts, and Secret Accounts. Consumers are advised to pay bills, make online purchases, payoff student loans and make other types of fraudulent transactions. As a result, millions of dollars’ worth of fraudulent ACH, checks, and electronic payments are being originated through PayPal, Venmo, and other payment vendors, utilizing a multitude of banks, credit unions, and financial firms as the originating institution.
In response to the overwhelming amount of fraudulent activity it continues to experience, the Federal Reserve System issued a news release (opens new window) warning that any video, text, email, phone call, flyer, or website that describes how to pay bills using a Federal Reserve Bank routing number or using an account at the Federal Reserve Bank is a scam. Additionally, the Federal Reserve stated that any transactions attempting use the Federal Reserve’s routing numbers would be rejected and returned unpaid.
More recently, the routing numbers of several financial institutions, including several credit unions, have appeared online and in social media. As a result, a number of credit unions have been affected by this fraud. Predominantly, the fraudulent activity is in the form of ACH transactions, but credit unions are also dealing with it in the form of fraudulent checks.
Typically, the scheme begins as a few ACH micropayments, incoming transactions typically under $1 in value. Then over a short period, the activity rapidly escalates in volume and dollar amount. This rapid escalation can overwhelm a credit union’s ACH operations when thousands of fraudulent transactions are received in a single day and must be returned timely in order to receive same- day credit. An assault of thousands of fraudulent, large-dollar transactions can also result in a massive settlement obligation for a credit union, greatly affecting its settlement account at the Federal Reserve or its corporate credit union.
It is likely that more credit union routing numbers will appear on social media or in other dark corners of the web. Therefore, credit unions, in their role as receiving depository financial institutions, should consider the following recommendations—or any other preemptive activity they deem appropriate—to mitigate the risks associated with this type of attack:
- Monitor the internet for mentions of your credit union’s routing numbers in social media and on websites, similar to how businesses monitor their names online as part of their reputation risk-management programs.
- Review your title and lien release procedures to ensure there is a waiting period after a payoff transaction is received before a title or lien is released.
- Monitor your ACH receipt files closely, specifically looking for:
- Spikes in debit settlement amounts that are higher than historical or expected norms; and
- Spikes in micropayments with invalid account numbers.
- Verify that the name associated with a series of micropayment matches the name on the account.
- Ensure all ACH transactions are posted on the effective date to ensure the timely processing of returns and that all returns are processed on the same day to receive same- day credit.
Finally, credit unions that are originating depository financial institutions should also monitor their payment systems for spikes in originations, return activity or both related to a particular routing number.
For Additional Information
FedACH customer inquiries can be directed to FedACH and Check Customer Support at 877.372.2457. Credit unions should also report instances of payments fraud to the Federal Reserve System by email at RTN.fraud@ny.frb.org.
Additionally, credit unions that have incurred a possible financial loss because of this or any other type of cyber fraud should contact the FBI’s Cyber Division (opens new window).