ABSTRACT
Introduction: This study aimed to assess the outcome of percutaneous transluminal angioplasty (PTA) as the primary treatment for transplant renal artery stenosis (TxRAS).Materials and Methods: A retrospective review of PTA of TxRAS from April 1999 to December 2008 was performed. Twenty-seven patients (17 males (M):10 females (F)) with the mean age of 49.5 years underwent PTA of TxRAS in the review period. Indications for PTA were suboptimal control of hypertension (n = 12), impaired renal function (n = 6) and both suboptimal control of hypertension and impaired renal function (n = 9). All patients had doppler ultrasound scans prior to their PTA. In addition, 5 of these patients had computed tomography angiography (CTA) and another 7 had magnetic resonance angiography (MRA) evaluation. Mean follow-up period was 57.0 months (range, 7 to 108 months). Results: The stenotic lesions were located proximal to the anastomosis (n = 2), at the anastomosis (n = 15), and distal to the anastomosis (n = 14). Technical success rate was 96.3%. One case was complicated by extensive dissection during PTA, resulting in subsequent graft failure. The overall clinical success rate was 76.9%. Seven out of 26 patients had restenoses (26.9% of cases). These were detected at a mean of 14.3 months post angioplasty (range, 5 to 38 months). All 7 patients underwent a second PTA successfully. Three of these patients required more than 1 repeat PTA. Conclusion: PTA is safe and effective in the management of symptomatic TxRAS and should be the primary treatment of choice. Close surveillance for restenosis is required and when diagnosed, re-angioplasty can be performed.
Renal transplantation has become a successful means of treatment for patients with end-stage renal failure. However, in patients with kidney transplants, graft dysfunction can occur as a result of transplant renal artery stenosis (TxRAS). This can present with raised creatinine levels or as refractory hypertension resulting in increased use of anti-hypertensive drugs. The incidence of renal artery stenosis in transplant kidneys is quoted as between 1% and 23%. The prevalence of arterial stenosis affecting renal grafts has increased in recent years due to the use of marginal donors and older recipients. TxRAS usually occurs between 3 months and 2 years after transplantation, but earlier or later presentations are not uncommon. Colour doppler ultrasound is used as a screening tool for TxRAS, but angiography remains the gold standard for diagnosis.
This article is available only as a PDF. Please click on “Download PDF” on top to view the full article.