The future of higher education is always just around the corner.
In reality, some concepts have hardly changed in hundreds of years, while others come and go so quickly they could be mistaken for a myth.
As things stand in 2013, institutions need to be ready to keep their current ground as well as prepare for growing trends in the short- to mid-term future. Long-term is a given, although my main reason to not mention it is because stakes are strangely higher in the short-term at the moment. As David Kernohan recently mentioned, “Institutional management has become an increasingly short-term enterprise”.
Whether you look at universities as competing elements or a bunch of diverse individuals, it would be wise to pay attention to what each institution is up to. A Russell Group member shouldn’t rest on its laurels, despite the perceptions of relative safety within such company. They should look further afield and pay attention to decisions made by new universities, private providers, and overseas players. Everything and everyone should be watched with interest.
That’s just an example. No matter where your university hangs on the tree of esteem, it’ll be worth checking out the strategic moves of others across a wide area. Perhaps you complain that private providers are only in it for the money, but if their surprise move successfully captures an active audience it’ll be up to everyone else to catch up. For some, it may be too late to catch up:
“…as many as 20 to 30 current…institutions could become unviable if student demand continues to fall.” [THE]
The quote above refers to concerns from HE leaders interviewed by PA Consulting Group. It looks like everyone is vying for as much audience as possible. The report found the biggest major concerns were of a decline in postgraduate student demand and further reductions in funding. The biggest moderate concern was an inability to grow alternative sources of profitable revenues. Hence the continuing need for healthy numbers of bums on seats.
This may annoy some readers. “Students should not be seen as pound signs.” “Using admissions as a way to tempt people and dump them with little to speak of later is a disgrace.”
And there is a fine line. Institutions clearly need to highlight unique selling points to get a steady stream of keen applications. However, as Janet Graham, director of the Supporting Professionalism in Admissions programme, says in today’s Times Higher Education:
“.”
In essence, a short-term view still requires a long-term attitude. All the more reason to keep track of new developments within a wide scope and at an early stage, so you can catch a glimpse of what’s playing out with time to breathe. Ish.
You may not wish to emulate particular success stories, partially in view of Janet Graham’s point above. However, you should build an understanding of what processes are working, whether they are relevant to your institution, and how you might be able to incorporate something similar into your plans.
Anything that seems dangerous or unacceptable may still contain useful fodder for your own future actions. You may be able to use it in a more reasonable way to make the point.
Plus, you can see where trends are starting to emerge. A small pool of providers may make a move toward something unusual, for instance. That’s a cue to assess what is going on and evaluate why the sudden interest is there. Always be on the lookout for clues. What looks strange today might be pretty standard tomorrow.
There is only so much you can do through surveys and studies and action groups. You won’t be first in everything. But when you’re not first, you should at least be aware so you can make well reasoned decisions to be close behind with a solid plan, rather than lag at the back in a frenzied attempt to mop up whatever is left.
Awareness also allows the confidence to dismiss some moves outright. Though mistakes are equally possible from this direction, none of us have a magical crystal ball lying around to get it right every time. Keeping careful watch and consideration is a reasonable alternative.
Question why new decisions have been made. Consider undisclosed background reasons behind why that direction is being taken. Could it work for you? Does it make sense? Is it reasonable? What’s missing? How can you find out more?
The short-term is where it’s at right now. That doesn’t mean the need for brash decisions. On the contrary, it often requires more consideration than ever.
One comment