SUMMARY
The effect of eucalyptus (Eucalyptus robusta Sm.) mulch on weed control was investigated in a newly planted, nonirrigated 'Tahitian' lime (Citrus aurantifolia Swingle) orchard in Mililani, Hawaii. Increasing mulch rate resulted in a decrease in weed dry weight and an increase in the tree trunk and limb diameters (combined), limb length, and total leaf count. A mulch rate of 150 tonnes/ha is recommended for providing satisfactory weed suppression and enhancing tree growth.
INTRODUCTION
Soil water availability and adequate weed control are two important factors that influence the growth and vigor of young orchard trees. Organic mulches help to conserve soil moisture by providing a protective cover on the soil surface. This has resulted in more vigorous trees by reducing the weed pressure and providing a nutrient-containing material for many orchard crops. Although the benefits of mulches are well documented, obtaining material and the high cost of application have limited its widespread use.
The objective of this study was to determine the potential of Eucalyptus robusta Sm. mulch to suppress adequately the weed growth and to enhance tree growth in a newly planted, nonirrigated 'Tahitian' lime (Citrus aurantifolia Swingle) orchard.
PROCEDURE
This study was initiated at Mililani, Hawaii, at an elevation of 340 m with an annual precipitation of 150-200 cm. The field was subsoiled to a depth of 46 cm and disked before tree planting. Two-year old 'Tahitian' lime trees grated onto Citrus volkamericana rootstock were planted in nonirrigated beds approximately 20 cm high with treatment plots 2 m wide by 10 m long. There were two trees centered in each treatment plot spaced at 5 m within rows and 5 m between rows. Trees were planted in blocks oriented in an east to west direction with the blocks in the middle of the orchard with several guard rows.
Treatments. The experimental design was a randomized complete block with eight replications. All but three main limbs, labeled "A", "B", and "C", were removed from the lime trees at planting. Eucalyptus limbs (maximum diameter 16 cm) and leaves were mechanically shredded into chips approximately 0.25 cm thick by 2 cm wide by 6 cm long and evenly applied to the treatment plots. Eucalyptus mulch rates of 0 (control), 100, 150, and 200 tonnes/ha were used.
Weed data. Weeds were hand harvested with hoes and sickles from a 0.5 m² sample area in the middle of each treatment plot. Sampling times for weed harvests were 169, 232, 302, and 372 days after the trees were planted. All aboveground weed biomass was oven dried at 72°C for four days and weighed.
Tree data. Tree growth data were taken 10, 113, and 354 days after planting. The trunk diameter of the scion 25 mm above the graft union was measured. Two measurements were recorded at the same height, rotated 90° about the trunk axis, and averaged to compensate for irregularities in trunk diameter symmetry. Trunk diameter was added to the sum of the limb diameter of the three limbs, each measured once 5 mm above the trunk/limb union. Lengths of the three limbs were measured from the trunk/limb union to the terminal end of the limbs. The combined limb length was used for analysis. Total leaf count for the three limbs was recorded for each tree. Data was subjected to analysis of variance and trend analysis to determine the effect of increasing levels of mulch on weed weight and tree growth
RESULTS AND DISCUSSION
Weed dry weight. As the eucalyptus mulch rate increased, the total weed dry weight decreased at the four sampling dates. Eucalyptus mulch at 200 tonnes/ha was highly effective in controlling weeds consistently throughout the 372 days after planting. Even with a large increase in weed dry weight for the other treatments in May (302 days after planting), the 200 tonnes/ha treatment still kept the weed dry weight at a low level. Total weed dry weight decreased linearly with increasing mulch rate at 169 and 372 days after planting. The most effective mulch rate for weed control at 169 and 372 days after planting was 200 tonnes/ha with the more pronounced effect at 372 days.
Trunk and limb diameters. At 113 and 354 days after planting there was a linear increase in the trunk and limb diameters (combined) as the mulch rate increased. Similarly, as the mulch rate increased, there was a linear increase in the total tree leaf number and limb length. The effect of the mulch was more pronounced at 354 days after planting.
The primary objective of a successful weed management program in a newly established lime orchard is to minimize economically the weed competition. This study showed that increasing eucalyptus mulch rate decreased weed dry weight. The 200 tonnes/ha treatment gave excellent results in inhibiting weed growth, an 18% reduction in weed dry weight compared to the 150 tonnes/ha treatment. This may have been partly the results of less weed seed germination due to the greater dampening effect of temperature in the soil beneath the 200 tonnes/ha mulch.
This study also showed that increasing eucalyptus mulch rate increased tree growth. Growth responses of the lime trees showed a greater response to the mulch rates at the end than at the beginning of the first growing season. The 200 tonnes/ha treatment did not dramatically increase tree growth compared to the 150 tonnes/ha treatment. At the conclusion of the study, the trees in the 200 tonnes/ha plots showed only a 4% increase in trunk and limb diameters (combined), a 1% increase in leaf number, and an 8% increase in limb length over trees in the 150 tonnes/ha plots.
In this study, the roots of the lime trees grew through the surface of the soil into the mulch in the 150 and 200 tonnes/ha treatments. The greater rates of mulch may have provided a source of moisture for the roots of the lime trees. Earthworm populations were considerably higher in the 150 and 200 tonnes/ha treatments than in the 10 tonnes/ha treatment and the control. The mulch also may have provided the worms with a more favorable temperature by insulating them from the desiccating effects of the sun.
Eucalyptus mulch can effectively suppress weed competition and increase tree growth and vigor in a newly planted, nonirrigated 'Tahitian' lime orchard. Rates below 150 tonnes/ha did not provide adequate weed control. All other rates of mulch provided commercially acceptable weed control while enhancing tree growth. The recommended rate of eucalyptus mulch application is 150 tonnes/ha, which adequately suppressed weeds and kept mulching economically feasible.
Top of page
K. Kobayashi's main page