Three weeks ago, just after Christmas, we learned that my husband, Mike, has testicular cancer.
We were in Thailand at the time, on a three-day getaway from our home in Laos. Mike had noticed something different downstairs ten days previously, and we’d scheduled an appointment to get it checked out in Thailand while we were there (Laos medical facilities are, shall we say, sub-par).
Right up until the day of the appointment, I wasn’t worried. The chances of it being anything serious are so slim, I reasoned. And after everything that’s already landed on us in the last two years – a baby’s broken femur, my broken ankle, depression, Mike’s two herniated discs and spinal surgeries – it’s so not our turn for this sort of medical drama anymore, amen.
I was carrying our five-month old and simultaneously trying to prevent our leashed and unhappy two-year-old from climbing into a fishpond, when Mike walked up to me after his appointment and said the words: “I have a tumor. It needs to come out as soon as possible. The doctor said it could be life-threatening.”
Well. So much for not our turn anymore.
As we were driving back to Laos the next day, Mike and I began to do something we’ve gotten rather skilled at doing – planning for how to deal with a medical challenge in Bangkok while we continued living in Laos.
During that drive home, we decided that Mike would leave ASAP to have surgery in Bangkok while I stayed in Laos with the kids. If further treatment was needed after that, we hoped that perhaps Mike could commute to Bangkok for radiation or chemotherapy and then return to Laos and work in between treatments.
It seemed like a good plan to us. It didn’t seem like such a good plan to two of our good Australian friends – both doctors – who are also currently living in Laos.
These two friends came around to our house that day after we arrived home from Thailand. Over the course of the next three hours they lovingly but firmly laid out all the reasons why, given Mike’s test results, we should all catch the first available flight to Australia.
Forty-eight hours later, one minute before midnight on New Years Eve, our flight from Bangkok to Brisbane lifted off. I believe we were being serenaded at the time by our exhausted two year old screaming in rotation, “COOKIE MAMA, RIGHT NOW!!” and “OFF PLANE!!”
Now it’s the 20th of January. We’re living at my parent’s house. Again. Mike had surgery in Brisbane six days after we landed in Australia. His tumor turned out, as expected, to be cancer. What we didn’t really expect was for a Stage 3 diagnosis. Lymph nodes in his groin and his chest have already been affected. I’m writing this article in the oncology unit, sitting beside Mike. The nurses are preparing to hook up the first treatment in what will be at least nine weeks of chemotherapy.
I am so profoundly grateful that we are not in Laos or Bangkok right now, and that our kids are being watched over by their grandparents while I’m here.
I was wondering yesterday what to write about this month that might be relevant to you all when this question popped into my mind: How will you know when it’s right to leave the field?
Our first inclination when Mike was diagnosed was to stay in Asia. We only decided to temporarily relocate to Australia because we invited, and then took, the advice of two friends who knew more than we did about what we might be dealing with.
One of those two doctor friends reassured us as we were still trying to process stepping away from Mike’s job, our house, and “normal” life for an indeterminate amount of time.
“The specifics about your house and everything else will sort themselves out,” she said. “They always do. And within six months this will all most likely be behind you. You’ll be back. You just need to step away for a while.”
What sort of situations or warning flags would make you decide to step away for a while, or even leave the field permanently?
Sometimes we’re faced with a pretty clear crisis point, like a cancer diagnosis, that raises the question of whether to go or to stay. Speaking as both a psychologist and someone who has been through a couple of those crisis points, I can tell you that no matter how calm you feel in the immediate aftermath of a crisis point, you may not be thinking logically and rationally. Right when you need to be making 101 important decisions, you will not be at your best.
Make up your mind now not to go it alone during those moments. Who will you trust to help you untangle your options and to give you advice? Think now about who could be a good sounding board for you then.
Beyond that, however, think about what sorts of seasons and reasons should cause you to at least consider leaving the field. In the absence of a specific crisis point, we can slowly acclimatize to all sorts of stresses and strains without realizing the extent of the pressure that we (or our relationships) are under. That proverbial frog in the boiling pot of water might have survived if he’d kept his eye on a thermostat. Along those lines, we should keep some of our own personal and relational thermostats within view when we’re living in potential pressure-cooker situations. When you choose to live overseas, it’s wise to identify some personal warning signs that should prompt you to reconsider whether your life overseas is worth the cost that you and your loved ones are paying.
What signs of marital strain would act as this sort of trigger for you? What about issues with your children, or your (or a loved one’s) faith, job, sense of vocation, or health? Where would you go if you had to leave the field on short notice?
Think about these questions this week. Talk about them with your partner, friends, or family.
I hope you never have to put any “emergency exit” scenarios into place. But if you do, I hope you’ll know when to leave and that you’ll have somewhere soft to land for a season while you sort out your life. On those fronts, at least, Mike and I count ourselves blessed.
Share your wisdom with us all. Have you ever had to make an emergency exit from your home abroad? What helped you during that time?
And, what sorts of reasons or seasons might prompt you to leave the field?
Lisa McKay – author, psychologist, sojourner in Laos
Website: Books: Love At The Speed Of Email and My Hands Came Away Red