What. This—to us strange—disciplinary situation had ancient roots: Aristotle’s most expansive discussion of the passions appears in his Rhetoric. Since early modern literary theory was based on rhetoric, this forges a direct relationship between literature and the study of passions.
What does it mean to think about passion rhetorically? One answer takes us to a famous Hamlet soliloquy:! (2.2.545–51)
This is about more than effective performance: it encodes an account of the cognitive underpinnings of passion that emphasizes the rhetorical functioning of the mind. The “fiction” Hamlet is thinking of is a mental fiction: a “conceit” or phantasm, which is a fiction in the sense that it is a made thing: a product of our souls. In the sequence traced here, an imagined conceit alters the soul and that alteration in turn alters the body. All passions are fictional in the sense that all are based on “nothing”: that is, on mental images. A second sense of “fiction” is relevant as well: fiction as that kind of made thing that is an invented story. The actor describes Hecuba at the fall of Troy; in doing so, he is both himself moved and moves those who hear him. The transmission of passion is not a secondary issue separate from what passion “is” but follows directly from passion’s relation to imagination: that is, its “fictional” standing. Literature can address the passions because passions are quasi-mimetic: they are ways of seeing and evaluating the objects of our concern.
The knowledge produced by a rhetoric of the passions is remote from what the early modern period called “scientia”: certain, demonstrative knowledge of universals. Even Aristotle’s chapters on the passions in the Rhetoric do not offer anything like that: they give brief definitions of each passion, but mostly offer ramified lists of the kinds of situations producing each. Early modern writers expanded on such accounts. The second edition of Thomas Wright’s Passions of the Mind—printed 1604, the same year as Q2 Hamlet—spends nearly 20% of its length surveying the “motives to love”: the means to move love in others. The discussion is divided into seventeen topics, from pardoning of injuries to gift-giving; that last is subdivided into fourteen further “circumstances,” addressing the nature of the gift, the giver, and the receiver, and the specifics of how the gift is given. There is nothing finished about either list: one could easily add more motives, more circumstances. And this is the point. Since passions are responses to the situations in which we find ourselves, they vary in as many ways as those situations vary. According to a common early modern phrase, passions are “accidents” of the soul, where “accident” means both a contingent qualitative alteration and an event. We study passions by looking out at the world of events. But the knowledge we can attain in this way is at best probable: as a series of seventeenth-century books argue, passions are caused by their objects; those objects are qualified and circumstanced particulars; they are infinite; and the passions too are infinite. Passions are at the limits of the knowable.
Rhetoric knows the passions by tracing them to their circumstances. That is, it knows them narratively, and it construes narrative as a means of producing knowledge about passions in their particularity. This way of knowing is evoked in Francis Bacon’s Advancement of Learning: “poets and writers of Histories” have been passion’s “best Doctors”—that is, best scholars—because in them we find depicted .”
Bacon wants a natural history of the passions to displace this unsystematic poetic and historical knowledge. It is tempting to say that this is exactly what happened in the next two centuries, as forms of empirical psychology took over a space that once belonged to rhetoric. But it matters that these psychologies reoccupied rhetoric’s terrain. The knowledge they offer is closer to the one Bacon ascribes to poets and historians than to scientia: in the sphere of the passions, rhetoric is the forerunner of an empirical knowledge of particulars. One can trace its continuing if hidden influence on new psychologies from Locke—who recommended Aristotle’s Rhetoric as part of the study of the passions—to Hume and Smith, whose models of the mind echo the psychology of the vivid image articulated by Hamlet and the circumstantial analysis of passions practiced by Wright. Scholars sometimes claim that a “psychological” approach to Shakespeare is anachronistic, because his period had no psychology. That is not entirely accurate, but the main point is that, in a sense, the period’s literature was its psychology: a circumstantial, open-ended, narrative knowledge of the passions grounded in rhetoric. That knowledge, which thrives beyond the limits of any system, still has something to tell us about how we know the emotions now—not as experts, but as people engaged in everyday life.
Feature image: Infant Shakespeare Attended by Nature and the Passions, The Elisha Whittelsey Collection, The Elisha Whittelsey Fund, 1949
Recent Comments
Excellent blog. I once heard Jane Smiley asked how to get more men to read fiction. She replied, “Anyone interested in people will naturally want to read fiction.” Because good fiction broadens and deepens our empathy for a wide range of people and their emotions, both similar to as well as different from us.