Pressure is growing against homoeopathy in the UK while it booms in India, says a two-part Special Report in this week's edition of The Lancet.
In the first part of the Special Report, Lancet senior editor Udani Samarasekera looks at the anti-homoeopathy momentum which has been building for the past two-years in the UK. The latest subject to irk anti-homoeopathy campaigners is a symposium on the role of homoeopathy in HIV/AIDS treatment which will take place in London on December 1, organised by the Society of Homeopaths. Michael Baum, professor emeritus of surgery at University College London (UCL) and frequent critic of homoeopathy, believes homoeopaths are getting overconfident. He says: "People say homoeopathy cannot do any harm but when it is being promoted for HIV then there is a serious problem."
Both Baum and his UCL colleague, professor of pharmacology David Colquhoun, are among a group of doctors and scientists who, last May, sent a letter to all Primary Care Trusts in the UK to raise their concerns about homoeopathy on the National Health Service (NHS). And their campaign seems to be having an effect, since in September West Kent Primary Care Trust stopped NHS funding for the Tunbridge Wells Homeopathic Hospital, one of five hospitals that provide homoeopathy on the NHS. Referrals to the London Homeopathic Hospital are also down compared with last year.
However, homoeopathy remains ever popular with the public, with the 2007 market estimated to be worth £38 million, expected to rise to £46 million in 2012. Baum thinks this public support could be due to the mistaken belief that homoeopathy is herbal medicine. He says:  â€œunethical and patronising."
To the dismay of many scientists and doctors, homoeopathy has received some unexpected support recently -- in the form of regulations from the UK Medicines and Regulatory Agency. However, unlike conventional medicines, to obtain a licence, manufacturers only need to provide safety evidence and information on what the remedy is traditionally used for. Baum believes the only way forward is for the UK's National Institute of Health and Clinical Excellence (NICE) to assess homoeopathy and issue guidelines. The UK Department of Health told The Lancet that NICE already consider complementary therapies alongside conventional treatments when developing clinical guidelines -- yet none of NICE's existing clinical guidelines recommend homoeopathy for any condition.
In the second part of the Special Report, journalist Raekha Prasad looks at the booming homoeopathy industry in India, where 100 million people depend solely on this form of therapy for their health care. It refers to the case of a man who sold his tractor to pay the 150000 rupees (£1800) to pay for a miracle homoeopathic cure for HIV, which, not surprisingly, had no effect, and his condition deteriorated.
SP Singh, the Indian ministry of health and welfare's advisor on homoeopathy, told The Lancet that homoeopathy does not give side effects, and that a small amount of medicine can serve a lot of people. And despite evidence to the contrary, Singh says "homoeopathy has a biological effect, and that all homoeopathic medicines are therapeutically proven." India is arguably unique in to extent to which it has recognised homoeopathy as a legitimate system of medicine.
This second part of the special report also draws attention to cross-practising -- where Indian doctors trained only in alternative medicine prescribe modern pharmaceutical drugs. It adds that the homoeopathic boom in India is being driven by wealthy Indians, who see it as a route to well-being.
In a related Comment, journalist and medical doctor Ben Goldacre, of the Guardian newspaper, London, UK, says homeopathy raises serious ethical issues: "When a health-care practitioner of any description prescribes a pill which they know is no more effective than placebo - without disclosing that fact to their patient - then they disregard both informed consent and their patients' autonomy."
He says homoeopaths irresponsibly undermine evidence based medical interventions to promote their own remedies, and points to evidence of homeopaths undermining public health campaigns, advising parents against the MMR vaccine, and offering ineffective homoeopathic prophylaxis for malaria, a fatal disease.
He discusses the fact that alternative therapy journals hardly ever publish negative studies, and that adherents "cherry-pick" only positive studies. "An observational study which amounts to little more than a customer satisfaction survey is promoted as if it trumps a string of randomised trials," he says.
In muddying the waters to promote their pills, homoeopaths undermine the public's understanding of what it is for a treatment to be evidence based. "This approach feels particularly egregious when academics are working harder than ever to engage the wider public in a genuine understanding of research, and when most good doctors try to educate and involve their patients, transparently, in the selection of treatment options."
He adds that these problems with homoeopathy "are exacerbated by society's eagerness to endorse the healing claims of homoeopaths, and by the lack of a culture of critical self-appraisal in alternative medicine."
Goldacre concludes: "To ban homoeopathy would be an over-reaction, as placebos could have a clinical role. However, whether the placebo effect is best harnessed by homoeopaths will remain questionable until these ethical issues and side-effects have been addressed."
The Lancet Press Office: T) +44 (0) 20 7424 4949 E) pressoffice@lancet.com
Raekha Prasad, Journalist, E) raekhaprasad@yahoo.co.uk
Ben Goldacre, Journalist and Medical Doctor, The Guardian, London, UK. Contact by email only E) ben@badscience.netFor more information:
Journal
The Lancet