Bilingual-education: a Berlin Wall for Turkish children
BERLIN, GERMANY — On a Monday afternoon, Berlin schoolteacher Sabine Sulflow's third-grade class is going over the grammar homework.
"Okan, would you please explain the homework to Rustem?" she asks a small boy with glasses.
"In German?" he replies.
It is a customary question, but one that will not be asked much longer in the Nurtingen Grundschule, Germany's first school to offer bilingual classes in German and Turkish.
In a move that parallels recent policy shifts in some communities in the United States, Nurtingen's decision to abandon its bilingual curriculum has far-reaching consequences, and one that is indicative of Germany's current dilemma over immigrant education.
Bilingual education in Germany began as a grass-roots effort at Nurtingen during the early 1980s. It was designed to help the children of Turkish immigrants, who were having trouble learning to read and write in German, a language that many could barely speak. The plan was to have Turkish and German instructors teach simultaneously, with the idea that a child who has a strong grasp of his mother tongue will be able to learn a second language more easily.
With roughly equal numbers of Turkish and German children in the class, the theory went, the German children would help their Turkish classmates learn to speak German. The concept caught on, and at one point 19 schools in Berlin offered Turkish-German education on the Nurtingen model.
Germany has a 2-million strong Turkish community. But the reality of poor and predominantly Turkish neighborhoods like Nurtingen has meant that many children, like Okan, ended up in classes with no native German speakers. At Nurtingen, only 20 percent of the children speak German as a first language. And German parents, says Ms. Sulflow, don't want their children to be in a class that is almost entirely Turkish.
"You can't put two German pupils with 16 Turkish pupils," says Sulflow. "Then the German [parents] will say 'No, thank you' and seek another school."
German educators and Turkish parents alike say that bilingual-educated children finish school with poor skills in both languages and little opportunity to integrate into German society. Today, only seven Berlin elementary schools still offer some form of bilingual education.
The immersion method
Nurtingen's principal Gerd-Jurgen Busack argues that putting the students into German-only classes, with no Turkish help at all, will get them speaking and reading German sooner. "In their families, they speak only Turkish. In school they speak only Turkish. Where should the kids learn German?" he asks. "Where is the motivation to learn German?"
But Sulflow, who gets eight hours of help a week from a Turkish teacher, says that putting immigrant children into a German-only classroom creates other problems. "When they come to school, there are so many words they don't know," he says. "It's necessary that they have someone [who can speak] in the mother tongue."
Nazim Akman, president of Nurtingen's parent-teacher association and a graduate of the school, agrees. "I know these problems," he says. "If you don't speak German, you don't know anything - what a color is, what a car is."
Although Mr. Akman has lived in Germany for more than 20 years, and was educated in a German-only classroom, he is not very fluent in German. Now a tile-layer in Berlin, and a father of three Nurtingen students, he would like his children to speak Turkish, German, and English fluently.
Right now, that seems unlikely. Conservative estimates suggest that 20 percent of Berlin's schoolchildren speak German as a second language. Half of them are Turkish speakers. Moreover, Turkish students are three times more likely than German students to drop out. And they are three times less likely to get the high school diploma needed to pursue a college degree. Similar problems are emerging in cities throughout Germany.
An outdated bilingual model
Although there are few statistics to back up their claims, some opponents blame bilingual programs. In reality, says Andreas Heintze, a teacher and developer of bilingual education programs in Berlin, only 1 percent of Turkish children are in bilingual programs. "It doesn't make sense to make us responsible," he says. "They say that bilingual education doesn't work, but the model they've had for the last 30 years doesn't work at all."
A new format, now being used by a handful of Berlin schools, requires equal numbers of German and non-German speakers in each class. These so-called "Europe schools" have existed for several years in such languages as French and English, and are designed to ensure that all students achieve fluency in two languages.
Six years ago, the city started a Turkish Europe school, the Aziz-Nesin-Grundschule, which has generated significant interest from both Turkish and German parents. Although its pupils are still ending up stronger in one language than the other, the principal, Christel Kottmann-Mentz, says she is pleased with the results so far. But Europe schools are expensive to operate and require special resources. At Aziz-Nesin-Grundschule, for example, bilingual teaching materials are hard to find.
So where does that leave Turkish-speaking students like Okam and Rustem? That is the question that most concerns Mr. Heintze. "The bad part about getting rid of bilingual education is for the schools themselves," he says. "They don't really have a good plan for the children, and there is no real alternative."
(c) Copyright 2000. The Christian Science Publishing Society