Hisham Matar's dreams of revolution and love
Hisham Matar’s second novel is a tale about the romantic love of a father and son for the same woman, as well as a compelling political story about the life in exile of an opponent of an oppressive Arab regime
“I, too, wanted secret meetings in Geneva, allies in Paris with whom I had watched history march and worked to change its course,” muses Nuri el-Alfi, the 14-year-old protagonist of Libyan expatriate Hisham Matar’s second novel. These thoughts of revolution take hold of the boy after dinner at a luxurious restaurant on the shores of Lake Geneva with his father, Kamal, a tense, secretive man who has escaped Muammar Gadhafi’s regime (although neither Gadhafi nor Libya appear in the book by name), and works underground with opposition groups to depose him. Why does it seem that exiled revolutionaries always seem to need expensive whiskey and fancy restaurants for inspiration, or at least as compensation for a failed uprising?
This book, however, is not the story of an unsuccessful revolution or of heroic revolutionaries. It is aimed at those who want to penetrate the hothouse of emotion behind revolution and feel for themselves the jumble of love, anger, romance and power that motivate the people who are eventually depicted in the media as heroes who changed the course of history.
The boy-man Nuri el-Alfi is involved in a romantic rivalry with his father that begins one pleasant summer on a beach in the Egyptian port city of Alexandria, where they move after Nuri’s mother dies. That’s the summer they both fall in love with a young Egyptian-British woman, Mona, who is there searching for her Egyptian roots. Kamal, a former adviser to the Libyan ruler, is 15 years older than Mona, while Nuri is 14 years younger. Within a short time, Kamal marries her, and Nuri gets a young stepmother, the object of his first serious crush. The rivalry continues for more than a decade, ending only after Kamal disappears mysteriously, apparently kidnapped and returned to his homeland by the Libyan regime.
But the book, which was published in English last year and is coming out now in Hebrew, is not merely the story of an impossible love triangle that just happens to take place in Alexandria. In fine and precise prose, Matar methodically builds a deepening love story, as well as a political one broken down into its emotional components, to the point that the story line, filled with plot twists, seems like it’s about to collapse under the weight of all these experiences.
Four cities
The people whose lives are charted in “Anatomy of a Disappearance” are not its only characters; the book is also about four cities. Geneva is the focus, a junction for the paths of the protagonists, the hub of Kamal’s secret activities and the place from which he is kidnapped. In addition to Alexandria, Cairo also plays a powerful role; it is where Nuri is born and where his mother and her family lived. Their unnamed homeland lies in the distance, unknown to Nuri except as the country of his admired father, who sends his son to England to study and forbids him to work until he has finished his education. “How is a young man to know himself if he is required to plunge into the first job offered him? Humility is not learned through humiliation,” the father explains to the son. And so London also enters the picture.
Each city has its place in constructing Nuri’s personality. The emotional chill of Geneva; London’s indifferent, minor-key elegance; the choking familial warmth of Cairo; and, of course, the setting for Nuri’s first love, Alexandria -- all contribute to the making of Nuri as a man of many experiences, but also as one who lacks roots.
The book is loosely based on Matar’s own life, as was his first novel, “In the Country of Men,” and it was completed just as the revolution in Libya began last year. Hisham Matar was born in New York in 1970 to a Libyan diplomat, Jaballa Matar, who was forced to flee the regime in 1979. From exile in Cairo, Matar’s father continued to oppose the Gadhafi government until he was kidnapped in 1990, apparently by Egyptian undercover agents. To this day no one knows what became of him. Several members of Matar’s family were executed by the Gadhafi regime, and when the uprising began, Matar, who studied architecture before turning to writing, started a campaign to enlist Western powers to attack and overthrow the dictator.
In his second novel Matar tries to be less overtly political and direct, and more contemplative. The beauty of his writing stems from the thin veil through which he describes his family’s tragedy and the skill with which he builds dramatic plot twists.
No less than it is about Matar’s own family, this book is also the story of the thousands of families of political activists in exile from Syria, Yemen, Iraq and Iran, cut off from their home countries while they conduct temporary lives, sometimes for decades. Some of them become absorbed by the daily grind of existence, some turn to business, and a handful continue in opposition movements, writing pamphlets or blogs and waving signs in front of their countries’ embassies.
Endless task
The dream of revolution that nourished Matar’s father and many other Libyan exiles is no longer relevant now that the revolution has taken place and the country’s guts have been spilled in the street, where they still lie scattered. Now the dream, albeit a distant one, is of a stable government. Violent and bloody power struggles threaten to tear the country apart, tribes are renewing old rivalries, and the ideal of democracy following closely on the heels of revolution is looking more and more like the stuff fantasy.
A year ago I met an Iranian exile who lives in London and spends most of his time working on an opposition website. “It’s an endless task,” he told me. “After all, even if we succeed in getting rid of the ayatollahs, we can’t be sure that their replacement will not see us, the revolutionary exiles, as a threat to the new regime.” Iraqi and Libyan political exiles who returned to their countries after their regimes were toppled know this dilemma well.
It is interesting to consider what the protagonist of Matar’s book, or the author’s actual father, would do today. Would he return to Libya to change the course of history, or keep waiting in Geneva or London to make sure he does not end up buried by history?
Zvi Bar’el is a commentator on Middle Eastern affairs for Haaretz.
Like us on Facebook and get articles directly in your news feed