» Monster diesels
Jan 1, 2008 12:00 PM,
By John Gilbert
Ford, Chevrolet and Dodge pickups are all equipped with new monster turbocharged diesel engines for the 2008 model year. While the manufacturers battle, the winners are really farmers, who will find new solutions for their need for towing and hauling power.
Ford has an entirely new F-450 for 2008, something the company calls a one-and-a-half-ton truck, with a newly designed 6.4-liter, common-rail, turbo-diesel V8 that produces 350 hp and 650 ft.-lbs. of torque. Those are the same power figures Dodge promotes for its new Cummins turbo-diesel in the Dodge Mega Ram, a 6.7-liter that generates 350 hp and 650 ft.-lbs. of torque with an in-line 6-cyl. against the competitors' V8s. General Motors equips its biggest Chevrolet Silverado and GMC Sierra with the 6.6-liter Duramax turbo-diesel V8, tweaked to 365 hp and 660 ft.-lbs. of torque.
All the pickups are so close in power that customers can choose whichever one they like best and know they aren't conceding anything under the hood.
The new engines can run on biodiesel, as well, meaning they will function on renewable energy that doesn't have the alleged fuel-efficiency drop-off of ethanol.
The U.S. car industry turned its back on diesel power three decades ago, when some hastily contrived diesel applications on existing engines blew up with alarming regularity from the much greater internal pressure of diesel operation. But there were other reasons for disliking diesels: They were loud, smelly, smoky, sooty beasts. Still, farmers kept using and appreciating diesel-powered implements and pickups, for their brute strength, durability and longevity.
Over the past year, implementation of a federal clean-air mandate to lower the level of sulfur in U.S. fuel brought the arrival of low-sulfur diesel fuel, which now must contain no more than 15 parts per million (ppm) sulfur. What was the standard before? A gluttonous 500 ppm.
The sooty residue, oily smoke and foul odor of diesels can be traced to that overdose of sulfur. Europe's cars ran clean, because its standards called for fuel with 12 ppm sulfur, and those standards have now been lowered to 5 ppm.
Improvements in common-rail fuel injection, turbocharging, particulate filters and catalytic converters, combined with the low-sulfur fuel, will improve every aspect of U.S. diesel pickups and could lead to a proliferation of diesel-powered cars, as well.
“It's been a wild ride for the last two decades, because it seems like diesels had new emissions hurdles about every three years,” says Jeff Caldwell, an engineer at Cummins Diesel, which makes the new 6.7-liter turbo-diesel for the Dodge Ram 2500, 3500, Mega Cab, and chassis-cab trucks. “Our engineers have done a fantastic job of anticipating the hurdles of changing regulations. We make so much power, but the emission laws are stricter on diesels. Ironically, the frustrating thing is that there might be no better solution to the high fuel prices than diesels.”
Caldwell has seen the shift in technology from the old two-stroke to the modern four-stroke combustion engine. Diesels use tremendous pressure instead of spark plugs to ignite the fuel, squeezing the fuel molecules with up to 24,000 lbs./sq. in. until they get hot enough to reach the engine's flash point and explode. A normal gasoline-powered car might inject fuel at 100 lbs./sq. in. because the mixture is ignited by spark.
The difference is that a diesel of the same displacement can produce stump-pulling power in multiples of its gasoline counterpart at much lower rpm. “We can produce tremendous force in the form of torque,” Caldwell says. “Cummins was the first to go to four-stroke technology, and we have a lot cleaner product today. Our new engine was designed to already meet the 2010 regulations.”
General Motors used to virtually concede the heavy-duty truck segment to Ford. But when it first switched to the Duramax diesels, built in conjunction with longtime diesel specialist and Japanese affiliate Isuzu in Moraine, OH, things changed.
“When we first introduced the Duramax in 2001, our market share was 3%,” says Susan Garavaglia, manager of powertrain communications for GM. “After we brought out the new Duramax for 2007, our market share is now 30%. We're making 200,000, which is capacity, and we'll sell as many as we can make.”
GM now offers the 6.6 in the three-quarter-ton and one-ton trucks, and Garavaglia says a new 4.5-liter V8 turbo-diesel will be produced in the Tonawanda, NY, plant for inclusion in the half-ton Silverado and Sierra by the fall of 2009.
While GM and Dodge fight it out for second among heavy-duty diesel pickups, the king of the road is Ford. Ford's diesel engines come from Navastar, which used to be known as International. Navastar is a customer of Cummins, particularly for its semitrailer engines, even though the two are competitors in the specialized world of diesel engine technology.
Ford's diesel engineer Rick Renwick says that cleaning up diesel fuel created guidelines that helped increase both horsepower and torque. “We ‘black-boxed’ the old diesel, analyzing how people had used their engines,” Renwick says. “We went through the equivalent of 10 million miles of testing and spent 63,000 hours running it on the dynamometer.”
The objective was to make the new 6.4 engine, with stronger components, to run smoother and more quietly. In the process, it was fitted with two turbochargers, with variable nozzles to control the speed of the turbochargers' spin. Renwick says engineers reduced nitrous oxide emissions and particulates by 50% each.
All the heavy-duty trucks are bigger and stronger than ever, and the addition of new and more powerful turbo-diesel engines not only levels the playing field, it tilts it to run downhill..