ALAMOSA — Staff of the Alamosa Mosquito Control District have been preparing for the Fourth of July since April.
“We started larvicide the first week in April, a week earlier than years prior,” Alamosa Mosquito Control District Manager Teyler Hurst said on Friday.
“We have been hard at larvicide ever since.”
It’s this kind of preventive mosquito control that has made the district so successful.
“Eighty percent of what we do is larvicide, trying to get them before they are in the air,” Hurst said.
Staff have been targeting mosquito larvae for many weeks now, but as a fully integrated district, larvicide is just one of the tools of their trade. Crews have also been regularly fogging areas within the district, which encompasses the city limits and an area outside the city bounded by the 2 South, 13 South and Roads 103 and 114, for a total of 121 square miles.
“They have been doing a great job,” Hurst said of the dedicated crew. “We have such a great phenomenal staff that are relentless and determined to ensure our quality of life is increased by the lack of mosquitoes. They are the backbone of what we do. They don’t get enough appreciation for it.”
Hurst said the district began fogging the last week in May right before Memorial Day.
“We’ve been hard at it since, as well. We’ve been fortunate the weather has cooperated. There have been only a few nights we weren’t able to get some spraying in.”
The weather also cooperated to allow the district to get in 11 flights with its airplane so far, as aerial application is another of the district’s tools in combatting mosquitoes.
Hurst said the district crew has been hitting the area within the district hard in preparation for Fourth of July festivities.
“We have been hard at it making sure the fairgrounds are ready for the fireworks show,” he said, “and trying to get it so everybody can enjoy their barbecues.”
He added, “We have been prepping for the Fourth, and we want to make sure everybody’s capable of enjoying it one way or another.”
However, he added, “No matter how much we do, there’s always a few mosquitoes that escape our grasp.”
He reminded residents the best ways they can keep from being bitten during this holiday and throughout the summer are the D’s: 1) Dusk and Dawn, avoid those times, as those are the times of day when mosquitoes are most active; 2) Drain standing water; 3) Dress appropriately, covering areas of exposed skin; and 4) and DEET — use insect repellant that contains DEET.
Every season seems to be unique with its own set of challenges, Hurst said. For example, equipment and weather have provided unique challenges for the district this year.
“Luckily we have a great staff, and we are a veteran staff that has been here, doing a really good job.”
West Nile Virus, which is one of many mosquito-borne illnesses, is not a threat yet, but the district will be closely monitoring the weather and mosquito traps to hit it head on if it arises. Hurst explained that the mosquitoes that carry West Nile are not active until temperatures hit and exceed 90 degrees consistently for a period of time, so the West Nile “season” is technically the end of July through the end of September.
“The risk increases with the hotter temperatures,” Hurst said.
Alamosa has been pretty fortunate with its temperatures in that regard, especially given that it’s now July, he added.
The district has also been fortunate in recent years not to register many West Nile Virus positives, with only one batch of mosquitoes testing positive for West Nile last year. It has been even longer that a human case has occurred here, Hurst said.
The district has 18 light traps throughout the district that provide a tangible way for staff to monitor where the problem areas are and to determine if any mosquito populations are testing positive for West Nile. The traps have been in place since the second week of May.
This process also helps the district target its resources most effectively.
“It’s meant to help us be better stewards of the environment,” Hurst added.
For example, if a light trap in town reaches a threshold of 25 or more mosquitoes, that part of town is targeted with mosquito control treatments.
And anytime that West Nile is discovered in a specific batch of mosquitoes, the district goes into full “shock and awe” to eliminate the threat. Crews will target a three-mile circle around the spot that tested positive and deploy every means necessary from larvicide to spraying to reduce the threat.
With that “shock and awe” approach, the district has achieved a 90 percent reduction of mosquitoes in the positive area and no recurrence of the West Nile Virus at that point.
Fortunately, Alamosa is at a high enough elevation and dry enough that it does not foster other illness-bearing mosquitoes such as those that carry the Zika Virus. However, the Alamosa district is one of several areas around the state where students from Metro State University are conducting a study to see if they can find any of those species here, specifically the Aedes aegypti. That species is not likely to be present here, Hurst said, since it is a tropical species more acclimated to places like Florida and tropical islands.
Aedes aegypti is also known as a “container-breeding mosquito” because it likes to lay eggs in and around standing water, and Alamosa has not had container species in the past.
“That’s not to say a truckload of tires couldn’t come across the border, and it could get here,” Hurst said.
Hurst said the mosquito control district has an open door policy, with anyone welcome anytime the office is open, without appointment, at 511 Fourth Street in Alamosa.
“We are a building full of mosquito nerds and we love to talk about mosquitoes,” Hurst said.
Even folks who live outside the district are welcome to come in for tips on measures they can take to reduce mosquitoes where they live.
The district makes it as easy as possible for area residents to contact staff and keep informed on mosquito control efforts. The main phone number is 589-5409, and the fogging hotline, to find out where the fogging trucks will be on any given night, is 1-877-919-5220. The district also has a web site with valuable information,
The district is also on Facebook, and Hurst tries to post on Facebook when aerial applications are planned.
On more recommendation from Hurst and the mosquito control crew: “We wish everybody a happy Fourth of July.”