ATHENS, Ga. -- When it comes to reproductive fitness, it seems that mother knows best -- at least when mother is Drosophila melanogaster, the common fruit fly. In a new analysis of earlier data, two scientists have found that the act of mating is far more harmful to females than the act of egg laying.
The differences are so striking, in fact, that the study may give clues to how females help control their own reproductive fitness, according to a University of Georgia geneticist who is co-author of the research, to be published in the journal Evolution.
"We propose that when females are in control, the costs to their reproductive fitness is minimal," said UGA's Dr. Daniel Promislow. "On the other hand, when males are in control, the costs are substantial." Co-author of the paper is Dr. Marc Tatar of the University of Minnesota.
Scientists have long known there is a tradeoff between reproduction and survival in the animal kingdom, but only recently have new studies in evolution begun to focus on issues of male versus female control. The tradeoff between reproduction and age-specific survival has been widely studied, but Promislow and Tatar in their new analysis focus on the fitness cost of reproduction rather than the survival cost.
Fruit flies are an especially fecund subject for such studies because of their mating habits and short lifespan, which covers from 30 to 90 days. Males and females engage in an elaborate mating ritual, during which males vibrate their wings in a "courtship song" and actually lick the females they choose. Copulation can last anywhere from a few minutes to several hours (depending on the species), during which the male injects into the female seminal fluid that included sperm and fluid from an organ called the accessory gland.
"It gets interesting at this point, because some sperm and the accessory gland fluids are stored in organs called spermathecae," said Promislow. "And the function of the accessory gland proteins appears to be to displace sperm from previous males or prevent the storage of sperm from future matings."
This chemical arms race has serious consequences for the females, who are subjected in this case to reproductive costs imposed by the males. This sperm competition, in fact, appears to occur at the expense of female survival. Both mating and the receipt of accessory gland fluid lead to an "almost immediate depression of female survival" and thus causes a great reduction in reproductive value.
Egg production, which is controlled largely by the female through feeding and other environmental strategies, also reduces female survival, but only relatively late in life when its effect of reproductive fitness is minimal.
The distinction between male- and female-controlled reproductive activities may seem fine, but the potential effects on evolutionary history are considerable.
Promislow and Tatar base their new model on earlier work done by Dr. Linda Partridge and Dr. Kevin Fowler. That work examined tradeoffs between egg production, mating and the receipt of products from male accessory gland fluid from fruit flies. Also important was work by Dr. Tracy Chapman, who determined that the mating cost of reproduction was influenced by the receipt of the male accessory gland fluid. The work of Dr. Larry Harshman and Tim Prout added to the study, since they first suggested that the main cell products of accessory gland fluid may be involved in sperm competition.
Interestingly, Promislow and Tatar found that the fitness costs of mating or the receipt of accessory gland fluid are substantial when a population size is decreasing but modest under conditions of population growth.
"We also found that fitness costs of egg production, however, are not strongly influenced by the rate of increase in the population," said Promislow.
While the evidence for female-controlled versus male-controlled reproductive fitness seems clear enough in the laboratory, it remains unknown whether or not the same is true in the natural world. Promislow and Tatar acknowledge that the difference in fitness costs of mating "might be an artifact of how flies are treated in the laboratory." For example, fitness costs of mating might be lower in the field than in the laboratory if females in the field encounter males less often than when they are confined in vials.
At the same time, fitness costs of egg production may be greater in nature than in the laboratory if adult nutrients are abundant in the laboratory and scarce in the field. As well, females' abilities to avoid predators in the natural world may be affected by egg load. Still, the new work makes clear that a full understanding of the evolution of life history strategies must incorporate behavioral and even physiological interactions between males and females.
"At the very least, we need to start distinguishing the costs that are under the female's control from those that aren't," said Promislow.
-30-
Story Source:
The above story is based on materials provided by University Of Georgia. Note: Materials may be edited for content and length.
Cite This Page: