Bazaar In-App Billing
Subscriptions
Subscriptions.
Overview of.
As with other in-app products, you configure and publish subscriptions using the Developer Console and then sell them from inside apps installed on Android devices. In the Developer console, you create subscription products and add them to a product list, then set a price and optional trial period for each, choose a billing interval (monthly or annual), and then publish. For more information about using the Developer Console, see Configuring Subscription Items.
When users purchase subscriptions in your apps, Bazaar handles all checkout details so your apps never have to directly process any financial transactions.
After users have purchase subscriptions, they can view the subscriptions and cancel them from the My Apps screen in the Play Store app or from the app's product details page in the Play Store app. For more information about handling user cancellations, see Subscription Cancellation.
In general the same basic policies and terms apply to subscriptions as to standard in-app products, however there are some differences.
To learn about the minimum system requirements for subscriptions, see the Version Notes.
Configuring Subscription Items
To add an item to a product list using the In-app Products UI, follow these steps:
1. Log in to your account.
2. In the panel, go to the menu Products/Services and click New Product.
3. provide details about the item you are selling. In the section, Kind of Product click Annual/Monthly Subscription and then click Submit.
You must enter the following information for each item in a product list:
SKU
Product IDs are unique across an application's namespace. A product ID must start with a lowercase letter or a number, and must be composed using only lowercase letters (a-z), numbers (0-9), underlines (_), and dots (.).
In addition, you cannot modify an item's product ID after it is created, and you cannot reuse a product ID.
Title
The title is a short descriptor for the item. Titles must be unique across an application's namespace. Every item must have a title. For optimum appearance, titles should be no longer than 25 characters.
Description
The description is a long descriptor for the item. Every item must have a description. The description is visible to users during checkout.
Price
You must provide a default price in IR Rials currency.
State
An item's publishing state can be Active or Disable. To be visible to a user during checkout, an item's publishing state must be set to Active and the item's application must be published on Bazaar.
Kind of Product
Choose Monthly or Annual period for your subscription product.
Dealer
Choose for which app is this product submitted.
Free Trial
Here, you can set up a free trial period that lets users try your subscription content before buying it.
Subscription pricing Developer Console, you can configure subscription products with automated recurring billing at either of two intervals:
• Monthly — Bazaar bills the customer’s account at the time of purchase and monthly subsequent to the purchase date.
• Annually — Bazaar bills the customer's at the time of purchase and again on the same date in subsequent years.
Billing continues indefinitely at the interval and price specified for the subscription. At each subscription renewal, Bazaar charges the user account automatically, then notifies the user of the charges afterward by email. Billing cycles will always match subscription cycles, based on the purchase date.
Over the life of a subscription, the form of payment billed remains the same — Bazaar always bills the same form of payment (such as credit card or by Direct Carrier Billing) that was originally used to purchase the subscription.
When the subscription payment is approved, Bazaar provides a purchase token back to the purchasing app through the In-app Billing API. Your apps can store the token locally or pass it to your backend servers, which can then use it to validate or cancel the subscription.
If a recurring payment fails (for example, because the customer’s credit is insufficient), the subscription does not renew. In this case the failed or expired subscription is no longer returned when you call getPurchases.
Free trials
In the Developer Console,, Bazaar records a transaction of $0.00 and the subscription is marked as purchased for the duration of the trial period or until cancellation. When the transaction is complete, Bazaar notifies users by email that they have purchased a subscription that includes a free trial period and that the initial charge was 0 RLS.
When the trial period ends, Bazaar automatically initiates billing against the credit card that the user provided during the initial purchase, at the amount set for the full subscription, and continuing at the subscription interval. If necessary, the user can cancel the subscription at any time during the trial period. In this case, Bazaar marks the subscription as expired immediately, rather than waiting until the end of the trial period. The user has not paid for the trial period and so is not entitled to continued access after cancellation.. You can change the period any time, although note that Bazaar Developer Console,, Bazaar does not offer a refund for the current billing cycle. Instead, it allows the user to have access to the cancelled subscription until the end of the current billing cycle, at which time it terminates the subscription. For example, if a user purchases a monthly subscription and cancels it on the 15th day of the cycle, Bazaar will consider the subscription valid until the end of the 30th day (or other day, depending on the month).
Important:
In all cases, you must continue to offer the content that your subscribers have purchased through their subscriptions, for as long any users are able to access it. That is, you must not remove any subscriber’s content while any user still has an active subscription to it, even if that subscription will terminate at the end of the current billing cycle. Removing content that a subscriber is entitled to access will result in penalties.
.
Refunds
With subscriptions, Bazaar does not provide a refund window, so users will need to contact you directly to request a refund.
If you receive requests for refunds, you can use the server-side API to cancel the subscription or verify that it is already cancelled. However, keep in mind that Bazaar considers cancelled subscriptions valid until the end of their current billing cycles, so even if you grant a refund and cancel the subscription, the user will still have access to the content.
Payment Processing and Policies
In general, the terms of Bazaar allow you to sell in-app subscriptions only through the standard payment processor of Bazaar.
Apps published on Bazaar that are selling subscriptions must use In-app Billing to handle the transaction and may not provide links to a purchase flow outside of the app and Bazaar (such as to a web site).