Many Deaths Still Expected With Earth-Penetrating Nuclear Weapons
A nuclear weapon that is exploded underground can destroy a deeply buried bunker efficiently and requires significantly less power to do so than a nuclear weapon detonated on the surface would, says a new report from the National Academies' National Research Council. However, such "earth-penetrating" nuclear weapons cannot go deep enough to avoid massive casualties at ground level, and they could still kill up to a million people or more if used in heavily populated areas, said the committee that wrote the report.
"Using an earth-penetrating weapon to destroy a target 250 meters deep -- the typical depth for most underground facilities -- potentially could kill a devastatingly large number of people," said John F. Ahearne, committee chair and director of the ethics program at the Sigma Xi Center of Sigma Xi, The Scientific Research Society, Research Triangle Park, N.C.
Many countries use underground facilities to conceal and protect military personnel, weapons, and equipment. Most of these facilities are beyond the reach of conventional explosive weapons and can be destroyed only by nuclear weapons. Earth-penetrating weapons have been considered as an alternative to conventional nuclear weapons because they could destroy such targets with up to 25 times less energy than weapons detonated at the surface.
The weapons' lower power would produce two to 10 times fewer surface casualties, but they still would lead to a large number of deaths and injuries, the report says. Fatalities could be further reduced if military commanders warned of an attack in time for people to evacuate. Commanders could also take advantage of wind conditions to minimize civilians' exposure to fallout. But a nuclear weapon burst in a densely populated urban area will always result in a large number of casualties, the committee emphasized.
Most of the weapons' destructive effect on a target is achieved at a depth of three meters. Beyond that depth, the weapon may fail, the committee said. Significant explosive power is needed to destroy targets located as deep as 400 meters, the report notes. For example, a 300-kiloton earth-penetrating nuclear weapon has a high probability of destroying a target 200 meters below, but a 1-megaton weapon is needed to destroy a 300-meter-deep facility.
The committee also examined the possible effects of using conventional or nuclear weapons to destroy chemical and biological weapons depots. Except for the BLU-118B thermobaric bomb -- a conventional bomb that can target a shallowly buried facility and destroy it with high pressure and heat -- conventional weapons are not likely to be effective in destroying chemical or biological agents, the report says. In a nuclear attack on a chemical weapons facility, far more civilian deaths will likely be caused by the nuclear blast itself than by the resulting dispersal of chemical agents. In contrast, the release of as little as 0.1 kilogram of anthrax spores, for example, would result in a number of fatalities similar to those caused by a 3-kiloton earth-penetrating nuclear weapon.
The study was sponsored by the U.S. Department of Defense's Defense Threat Reduction Agency. The National Research Council is the principal operating arm of the National Academy of Sciences and the National Academy of Engineering. It is a private, nonprofit institution that provides science and technology advice under a congressional charter. A committee roster follows.
Source: National Academies