Read the Original Article at
Google on Wednesday outlined its vision for the Internet, which will include a broad scope of technical ambitions using the collective power of developers, the Web, and cloud computing as its base.
"At a very high level, Google cares about moving the Web forward," said Vic Gundotra, engineering VP at Google during the company's I/O developer's conference in San Francisco. "The Web has become the dominant platform of our era."
Gundotra outlined the issues faced in the mainframe era, the personal computer era, and the Internet era. In the mainframe era, he said, computing power was not very accessible, but software was relatively easy to deploy. That changed in the PC era, when we gave up power and ease of software management for accessibility. With the rise of the Internet, the browser again made online software easy to deal with, but the browser lacks the power and flexibility of desktop applications.
"At Google, we believe we can solve these problems by making the cloud more accessible and by making the client more powerful," said Gundotra.
Gundotra repeated Google's mantra that making the Web better benefits Web users and Google. "We probably are the company that's most incented to move the Internet forward," he said.
And for those developers weaving tomorrow's Web line by line, Gundotra, his colleagues, and Google-allied partners showed what could be done with Google's latest programming tools.
There was Allen Hurff, senior VP of engineering at MySpace, who showed how the popular social network had employed Google Gears to enhance the search function in MySpace mail. Google Gears, introduced a year ago, provides a way for online applications to function offline by providing persistent storage and synchronization.
Steve Horowtiz, engineering director for Google's Android mobile phone platform, demonstrated that you don't need an iPhone to have an appealing mobile interface and compelling mobile applications. When he showed how an Android phone, using an internal compass, could dynamically adjust Google Street View images to match the facing of the phone user, there was a collective gasp and applause.
Kevin Gibb, technical lead for the Google App Engine, declared that Google wants make it as easy as possible to create and scale Web applications. That's why Google exposed its infrastructure to developers with the limited release of Google App Engine about a month and a half ago. And that's why Gibb declared that the Google App Engine is now open to everyone.
Gibb said that use of Google's infrastructure would remain free for applications that generate up to 5 million views per month and require less than 500 MB of storage. After that, pricing is as follows: $0.10 - $0.12 per CPU core-hour; $0.15 - $0.18 per GB-month of storage; $0.11 - $0.13 per GB outgoing bandwidth; and $0.09 - $0.11 per GB incoming bandwidth.
If it all sounds a bit like what Amazon has been doing with Amazon Web Services, Google thinks so too. Gundotra acknowledged a debt to Amazon for developing the rent-a-cloud business model.
Gibb also announced the imminent release of two new Google App Engine APIs: an imagine-manipulation API and the memcache API, for making application Web pages render more quickly.
Mark Lucovsky, technical director at Google, came to urge the use of Google's GData and Ajax APIs. Google in fact is now hosting a number of AJAX Libraries, so developers looking for the performance improvements these libraries can provide can just insert JavaScript tags that point to the libraries on Google.
Bruce Johnson, engineering manager for Google Web Toolkit, arrived on stage to announce that Google Web Toolkit 1.5 Release Candidate (GWT) would be available later this week. GWT is an open-source suite of programming tools and libraries that allows developers to write applications in Java -- Java 5 language support is a new addition -- and then cross-compile into equivalent standalone JavaScript that's compatible with a variety of Web browsers.
Finally, Google engineering director David Glazer, touted Google's OpenSocial API, now at version 0.8. "Things are coming together beautifully," he said, noting that killer apps like e-mail have traditionally been social applications.
Google may have been defeated temporarily by the unexpected number of developers drawn to its vision, but it nonetheless sees itself on the winning side, on the side of the Web.
"After years of competition among platforms, the Web has won because it's open, because it's ubiquitous, and because there's a passionate community working together to move it forward," said Gundotra in a."
In a landscape littered with potential Google rivals, it seems premature to declare victory. But as Google and the Web become ever more interdependent, it becomes harder and harder to bet on another horse.