by Elaine Stewart, Library Associate
Originally published by Columbia Daily Tribune [1].
In an episode of a popular television sitcom from some years ago, a character suddenly realizes he is the embodiment of failure. He is soon convinced that “if every instinct he has is wrong, then the opposite would have to be right” and quickly finds success by reversing all of his behaviors. As amusing as that TV scenario was, the real-life task of beginning anew is rarely so easy. Whether it’s finding a new career in a transformed job market, adopting more skillful interpersonal behavior or ridding oneself of an unhealthy habit, the process of change is likely to be difficult — yet, when success finally comes, the effect is profound. In January, the month notorious for resolutions made and soon given up, it makes sense to look for a reliable route to achieving real, long-lasting life changes.
Sometimes a flash of insight is all it takes to ignite the motivational fires. Elise Ballard’s “Epiphany! [2]” (Harmony Books, 2011), offers personal accounts of life-altering awakenings from such luminaries as Maya Angelou, Desmond Tutu and Deepak Chopra, among others. Good advice from a mentor made all the difference for the subjects of Katie Couric’s “The Best Advice I Ever Got: Lessons From Extraordinary Lives [3]” (Random House, 2011). The book gives perspectives on success from public figures Couric interviewed over the years, including the likes of Bill Cosby, Jimmy Carter, Meryl Streep and Ken Burns.
Inspiration is all well and good, but a day comes when a plan is needed to make something happen. Kerry Patterson’s “Change Anything: The New Science of Personal Success [4]” (Business Plus, 2011) asserts that willpower isn’t the answer, but rather, recognizing and using all the persuasive factors in your life. In “Switch: How to Change Things When Change Is Hard [5]” (Broadway Books, 2010), Chip and Dan Heath show that successful change follows a recognizable pattern that can be used as template for any type of personal transformation. Kim Marcille Romaner uses principles of quantum physics to demonstrate how the mind can reinforce desired outcomes and stifle unwanted ones in “The Science of Making Things Happen: Turn Any Possibility Into Reality [6]” (New World Library, 2010).
“Redirect: The Surprising New Science of Psychological Change [8]” (Little, Brown and Co., 2011) by Timothy Wilson proposes that mentally framing experiences positively is the most effective way to achieve goals. Gretchen Craft Rubin relates how she experimented with this kind of positive thinking in “The Happiness Project: Or, Why I Spent a Year Trying to Sing in the Morning, Clean My Closets, Fight Right, Read Aristotle, and Generally Have More Fun [9]” (Harper, 2009). Jeff DeGraff, known as the “dean of innovation,” uses insights from the business world in “Innovation You: Four Steps to Becoming New and Improved [10]“ (Ballantine Books, 2011) to demonstrate that self reinvention requires the same kind of “outside the box” thinking used by successful entrepreneurs. “Empowerment: The Art of Creating Your Life as You Want It [11]” (Sterling Publishing, 2011) by David Gershon and Gail Straub offers a workshop approach they have perfected through years of helping clients attain better lives. For those who prefer a boot-camp route to change, consider Larry Winger’s “Shut Up, Stop Whining, and Get a Life: A Kick-Butt Approach to a Better Life [7]” (Wiley, 2011). Winger, who is often billed as the “world’s only irritational speaker,” has a simple formula for success: quit blaming others and take responsibility for your life.
Adversity can occasionally be motivating, but too often conflicts, either at home or at work, are stumbling blocks to change. When there is a real need to stand one’s ground, “The Squeaky Wheel: Complaining the Right Way to Get Results, Improve your Relationships, and Enhance Self-Esteem [13]” (Walker and Co., 2011) by Guy Winch offers a guide to the fine art of expressing grievances effectively. Steven Covey, author of “The 7 Habits of Highly Effective People [14]” (Free Press, 2004), suggests a thought-provoking approach to conflict resolution in a new book, “The 3rd Alternative: Solving Life’s Most Difficult Problems [12]” (Free Press, 2011). Covey details a route to compromise that isn’t “your way or my way,” but a third way that goes beyond a truce and brings both parties to a new awareness of the situation. Guy Kawasaki, former chief evangelist of Apple Inc., believes setting goals isn’t enough to “make the sale” in business or in life. In “Enchantment: The Art of Changing Hearts, Minds, and Actions [15]” (Penguin, 2011), Kawasaki uses personal narratives to illustrate how to win over the hearts and minds of any adversary.
In a time when every aspect of our work and social lives is affected by economic and environmental uncertainty, author David Wann offers insight into changing the fabric of society itself. In “The New Normal: An Agenda for Responsible Living [17]” (St. Martin’s Griffin, 2011), Wann proposes a new agenda for living that includes responsible interface with our fellow humans and our planet. “The Nature Principle: Human Restoration and the End of Nature-Deficit Disorder [16]” (Algonquin Books, 2011) by Richard Louv shows how mental capacity and creativity can be enhanced through the healing powers of nature. He contends that closer contact with the natural world will promote health and well-being in individuals, businesses and communities.
Finally, for those who are overwhelmed by the prospect of radical change, deciding to take one small step might be enough. Consider adopting the Chinese tradition of doing a thorough housecleaning to get rid of the old year’s bad luck. Because the Chinese New Year starts on January 23 this year, you still have another couple of weeks to get started!