Green Tunnel Vision
Let’s play the sustainability word association game: climate change. Arctic. Oil. Extinction. Carbon emissions. Recycling. At Dickinson, we can add the Treehouse, Farmers on the Square, Kaufman, and no more napkins to that list. Aside from sustainability, these words have an underlying theme in common—they all relate to environmental issues. There is something potentially harmful in the way we depict sustainability, this green tunnel vision of ours.
Part of the problem lies in how environmental issues are approached, as though they are only relevant in glaciers and rainforests. Perhaps we have forgotten that any setting, from a dorm building to drought-ridden Syria to Gettysburg, 1863, is an environment. The natural and built environments do not exist in isolation, for even in the forest you can sometimes hear planes soaring overhead. A community garden is part of nature, but it’s also human-made.
Furthermore, sustainability does not apply exclusively to nature. Economies, countries, and civil society likewise must be sustained for humanity to continue to function. In some cases, like our consumption-driven economy or autocratic regimes, that means change. We have to devote more attention to the necessity of perpetuating a relatively organized, connected world if we want to sustain natural resources.
I think we forget that humans are natural too. We murder and create. We do a lot of harm to this good world, but we are part of it, not an alien blight upon the earth. We forget that, because we are responsible for so many environmental and societal problems today, we have an obligation not only to stop destroying but also to rebuild. Are we superior to nature? Certainly not—because we are nature. Humanity cannot abandon the earth to nurse its wounds alone.
From that recognition of humanity, it follows that we must devote more attention to societal sustainability and to how environmental issues affect society. I speak here of social justice movements as key to making our present world more equitable in the long term, and of environmental justice: how does your hydropower plant or green clothing affect your neighbor 500 miles away?
On Dickinson’s campus, I think our social justice-oriented groups like Spectrum can be recognized in the quiet ways they promote societal sustainability; they also must be better integrated into our school’s understanding of that topic. Because of what we hold in common—the opportunity to attend or work at an institution admirably aware of environmental issues—we need to foster an awareness of how sustainability goals interact with our differences in religious, ethnic, class, and other identities.
On paper I’m pleased with Dickinson’s definition, which says, “Sustainability is about more than recycling and the environment. [It is about how we] improve the human condition equitably in this and future generations, while conserving environmental systems necessary to support healthy and vibrant societies.” In practice, I am less satisfied.
For example, a great number of our classes are designated Sustainability Connections (SCON) or Sustainability Investigations (SINV), but that initiative has little recognition among students overall. Having taken some of those classes myself, I see how they are tied to sustaining the environment, economy, society, etc., but I cannot imagine how a student who thinks “sustainability” and “going green” are identical could understand that. Especially with SCON, Dickinson has a secret strength, but it is under-acknowledged and therefore ineffective.
Unless we recognize the true width and breadth that sustainability touches, we are at risk of focusing on our very difficult environmental situation to the detriment of everything else. We risk pessimism that leads to passivity. We act as if sustainability is a bumper sticker when it should be our world.
I challenge you to bring up sustainability in a club or classroom where it’s not normally discussed, and see where the discussion goes from there. These are the seeds of the future that we must plant.