What are adhesions?
Adhesions are fibrous strands attaching together organs that are normally separate.
Types of adhesions:
Flimsy
Dense
Very dense, fibrous and vascularised (with new blood vessel formation)
Clinically adhesions can be described as scar tissue resembling cling film, which makes organs stick together. Normally the pelvic organs slide against each other in the peritoneal cavity (the lining within the abdomen and pelvis). The organs in the pelvis are closely packed together. In endometriosis the inflamed areas and local irritation can lead to the formation of adhesions, making the organs stick to one another.
What are the causes of adhesions?
Infection – any type of infection can lead to adhesions if it is not treated quickly and adequately.
Surgery – any type of abdominal or pelvic surgery including that for endometriosis.
Inflammation – especially pelvic inflammatory disease. It can also be produced following miscarriage and normal delivery and can be sexually transmitted. Inflammatory bowel diseases (ulcerative colitis, crohns disease) or a ruptured appendix may lead to adhesions.
Endometriosis
How are adhesions formed?
Any damage to the peritoneum (the lining that envelopes the pelvic and abdominal organs) causes the release of certain chemicals – histamine and kinins. This leads to dilatation of blood vessels causing leakage of fluid from the blood vessels into the pelvis, abdomen or affected organs. This fluid is rich in proteins; it produces clots that are known as fibrin strands. These sticky strands of fibrin bind the organs together causing what we know as adhesions.
How common are adhesions?
Adhesions are rare in normal fertile women.
There is an increased incidence of adhesions in infertile women especially those with pelvic pains.
There are 50 to 100% chances of adhesions following pelvic and gynaecological operations:
a) Ovarian surgery ~90%
b) Fibroid surgery (myomectomy) ~90%
c) Endometriosis surgery ~80%
What are the problems/ symptoms caused by adhesions?
Adhesions can be asymptomatic (without symptoms). Loose adhesions do not cause any pain.
The main problems occur when organs become stuck together, when they should normally slide freely against each other.
1. Pain – can be local or deep in the pelvis. Post-operative adhesions can give rise to chronic pain although some medical practitioners do not believe in it. However it stands to reason that pulling of the organs away from their normal position will cause a varying amount of discomfort or pain.
2. Dyspareunia – pain during intercourse. This is caused when the ovaries become stuck down and by local trauma during deep penetration.
3. Bowel obstruction – dense adhesions can cause kinking and stricture of the bowel, in severe cases it can cause obstruction, which will need further surgery – can be mistaken for irritable bowel syndrome.
4. Bladder problems – adhesions can reduce the capacity of the bladder and the proper emptying of the bladder causing pain and frequency – can be mistaken for cystitis.
5. Infertility – can be produced by adhesions affecting the tube, ovary or lining of the uterus (womb)
What can be done for adhesions?
Adhesions cause widespread problems for the surgeon. Once adhesions are formed they can only be dealt with by surgery (adhesiolysis). Even with the best form of surgery adhesions reform in more than half of the cases treated. Under the circumstances the best option is to try to avoid the formation of adhesions in the first place. This can be achieved by:
Gentle tissue handling.
Meticulous care to stop bleeding during surgery.
Use of fine inert suture (stitching) material.
Control of infection.
Avoiding the drying of tissues during surgery.
Taking vitamin E makes the scar tissue supple and flexible so can help the
pain caused by adhesions.
Exercise helps to make the adhesions flexible and reduces pain.
Use of natural tissue or synthetic material as grafts to cover raw surfaces after surgery.
Prof T C Li
Consultant Gynaecologist
7 Williamson Road
Sheffield S119AR
Tel: 0114 2550365
July 2004