With a focus on the future, the organization is set to unveil a video conferencing platform.
The Global Market Development Center (GMDC) built its reputation on the concept of connectivity. Now as consumers’ purchasing habits become more influenced by digital means, the Colorado Springs, Colo.-based organization is helping its industry members address this transition through its own digital innovation. Set to premiere at its annual conference next month, the video conferencing technology will take GMDC’s face-to-face meetings to a new level, enabling retailer and supplier members to digitally connect with more decision-makers than ever before, say association officials.
GMDC’s long-time mission has been to enable the growth of retail and wholesale general merchandise and health beauty wellness categories through the use of collaboration, productivity and knowledge. When the group was ready to create even more value to its membership, it went straight to the source.
“Our members told us we do a great job, but now we need to enhance it,” says Mark Ciccone, the association’s executive director of innovation. “The key word that best describes us is connectivity. Now we are working to enhance our core competency with the addition of new things.”
A major catalyst of this change is the new pressures retail members are facing. Specifically, they are watching consumers’ paths of purchase take new directions due to their immediate access to digital solutions that aid in the shopping experience—pre-purchase, at the shelf and post-purchase.
Today’s shoppers use laptops, tablets and smartphones to educate themselves about merchandise before visiting their favorite supermarket. Personal mobile technologies enable consumers to do price comparisons and evaluate product through online shopper reviews and social media allows them to share their experience via social media networks, such as Twitter and Facebook—all aspects that influence brand perception. This is especially evident as they shop the general merchandise, health, beauty and wellness categories.
“The path to purchase in these areas is profoundly digitally influenced,” Ciccone says. “Whether it is before they enter the store, while in the aisle, or post-purchase, they are using mobile solutions to look for information and they use social media to educate themselves. In fact, we are watching up to 15% of some general merchandise category purchases moving online. It is our job to understand what retailers can do to drive this traffic back through the brick-and-mortar environment and help our retailers achieve this goal.”
The other factor influencing GMDC’s new direction is the impact of the economy on the trade show industry. “Many companies are navigating with downsized teams, which causes less direct interactivity at trade show events,” explains Dave McConnell, president and CEO of GMDC. “This is pushing us harder to connect all of the right people on the supply side.”
The most efficient way to achieve this is to use technology as an enabler. In fact, technology solutions become even more paramount as the next generation of GMDC members continue to tap the organization. “This group is into technology and wants us to exploit it as much as possible,” Ciccone says.
New service initiatives
In addition to this group’s motivation, McConnell agrees that the only way to stay innovative is to find new ways to deliver service. “We are looking at what the industry is lacking and what we can offer that will differentiate ourselves and still successfully facilitate connectivity, collaboration and partnerships on different levels,” McConnell says.
To support these efforts, McConnell appointed a new board to uncover opportunities for GMDC’s members. Called the President’s Innovation Network, the group is comprised of six members, all industry executives and GMDC members representing retailers, manufacturers and the trade show industries. The team suggests new innovative concepts and directions that GMDC might pursue, ensuring that GMDC is delivering programs that truly will facilitate change that benefits the organization and its members.
More specifically, this group is heavily focused on the capacity and capabilities of innovation. Their goal is to evaluate concepts that can expand connectivity among members and to other thought leaders inside and outside the industry.
The group expects to apply its research and up the connectivity ante by reinventing the trade show. In an era when attendance is down due to retailers’ razor thin travel budgets and smaller staff sizes due to downsizing, trade shows industry-wide are looking for new concepts to appeal to a wider audience. GMDC sponsors two conferences a year, each lasting four days. “Our members tell us that these are the most productive eight days of business they have a year,” Ciccone reports.
As more retailers need to contain travel costs, not all buyers and decision-makers can make it to the annual show, leaving holes and missed opportunities in general merchandise, health, beauty and wellness category decisions. By focusing on a new, highly immersive video platform called Telepresence, association officials say they are striving to change the tide. GMDC is working with a technology partner, which will be announced shortly, to create an online, two-dimensional virtual platform that connects executives in multiple locations and allows them to continue collaborative conversations centered around buying decisions, education or other value-added events.
While the concept resembles what many individuals already experience through Skype or FaceTime, Ciccone expects Telepresence’s high-resolution platform to raise the bar even higher. “Skype is good, but it is low resolution and typically it is a small screen execution,” he explains. “Telepresence is not only high-definition, but users in different locations feel like they are in the same room together. There is also no latency or lag time, making it an immersive experience.”
GMDC officials plan to pilot the Telepresence concept at its annual General Merchandise Marketing Conference, in Orlando, next month. Here, GMDC will use the platform to present “The Path to Purchase” session, as well as on the Showcase floor to connect retailers and wholesalers during supplier meetings. “If we can expose more suppliers and retailers through Telepresence, we are enhancing connectivity,” Ciccone says. “We expect this to support collaboration among both groups and create more meaningful, efficient discussions.” He says GMDC plans to add this “hybrid concept” to other events going forward.
Beyond meetings, GMDC is exploring how to apply Telepresence to educational platforms, roundtables and partner events. This will involve new content to include an emphasis, for example, on teaching members about path to purchase. GMDC is also exploring how to use the video conferencing platform to launch hybrid, or virtual conferences where all participation and sessions will occur over the platform—a cost-efficient opportunity for both the organization, and its members.
“GMDC’s overall goal is to connect members in the most meaningful way every day,” Ciccone adds. “This is the future of connectivity, and technology is the enabler.”