All across time, there have been epic battles. David vs Goliath, Intel vs Motorola, RAW vs JPEG. And of course, film vs digital. Everybody has opinions on this, so why should I be any different. I took pictures on film for about 20 years before I had my first taste of the art of photography. I shot on film with a Nikon F90X and two lenses: a 24-120 and a 70-300. This past October, I bought a Nikon D80. I really wanted the D200, but since the image sensors are the same and both will be obsolete in three years or so anyway, I put money I saved towards the fantastic Nikkor 18-200 VR lens.
My very first (non-test) photo was of my son eating a snack. With no flash, the D80 went up to ISO1600 with f3.5 and the result was a surprisingly great picture. There is little noise, excellent exposure, and amazing clarity. I couldn’t have done this with my standard (for indoor) Fuji400 film. All hail digital! Right? Not so fast…
I then took the D80 up to a “lookout” point to capture a sunset. It took great pictures, but either the sky was blown-out or the landscape was too dark. I could lighten it with Gimp or Photoshop, but it was already ISO800 and the noise didn’t look so good. I’d never had that trouble with film. Why? Because film over-exposes better than a digital sensor. As it approaches maximum exposure, film begins to slow down. It effectively compresses a large exposure range in to the top end, and does it gently so that colors just desaturate (become less vivid but retain the same hue) to white. This is usually referred to as the “shoulder” of film.
Digital sensors, on the other hand, are linear. They just sit there counting photons (”light bullets”) up to their maximum value at which point they stop. That’s pure white or worse. I say “worse” because red, green, and blue are “counted” separately; a colored source will saturate one of the color chanels first while the others continue to increase. That creates wierd color bands around the overexposed object. Take a look at the following example. It’s a gradient of 2R+1G+0B counting from 0 to 100 and limited to a value of 100 per channel (just like a digital sensor). Note how it’s a nice smooth increase of the same hue until the mid-point, at which time red clips to the maximum value. For the right half, red is now fixed at 100 but green continues to increase, changing the color to magenta (or 1R+1G+0B equivalent).
Film also captures all three colors at every point. Digital sensors (all but Fovian, anyway) capture only one color at each point and then interpolate between them to create a proper RGB image. Film will therefore be sharper than digital if converted at the same number of megapixels. Exactly how many megapixels you can get from a film scan depends on the film being used, but 4000dpi (24 megapixel for 35mm film) is about the theoretical limit. Despite this huge descrepency between film (24MPx3) and digital (10MPx1), for practical purposes the 10MP digital sensors of today are about comparable to common, non-professional film for resolution in the final image. Many lenses cannot resolve finer than this.
Another advantage of film is that it only costs 10x as much to create a negative 10x the size. Increasing today’s digital sensor to 10x the physical size might cost 1000x as much to create, if you could do it at all. That’s why you can find 4×5 inch film cameras but no corresponding digital ones. It’s also why most DSLRs use smaller APS-C size sensors. If you want extreme resolution for billboards or super-sharp, poster-size prints from a single frame, you need big film.
What does all this mean? Over the past months, my basic discovery of digital vs film is this:
It’s easier to capture a good image with digital, but you can get a better capture with film.
Which is more important to you? Me, I’ll stick with my D80 for now and hopefully one day get around to playing with a 4×5 view camera.
0 Responses to “The Generation Gap”