What if more than 150 people built a network from the ground up in a couple of days, ran it for less than a week, and then tore it down? What if each of those people was a volunteer? And what if that network was, for its brief lifespan, the fastest in the world?
That’s how SCinet, the network backbone of the annual Supercomputing (SC) conference and so much more, happens.
“It’s like a gift. A fantastic opportunity that not many people get to do,” said Caroline Weilhamer, manager of operations for I-Light and Indiana GigaPOP. She’s been a SCinet volunteer many times over the years, and at SC16 she co-chaired the Network Research Exhibition (NRE) team, one of the many volunteer-powered groups that make sure SCinet performs its many functions flawlessly.
What may seem like an unenviable undertaking—setting up a network and making sure it performs as advertised, only to take it down a few days later—is actually an incredible opportunity in disguise, said Weilhamer.
“Instead of viewing it as a hardship because it’s a volunteer base, people should grasp how invaluable all the knowledge is that each of the volunteers is exposed to,” she said.
“It’s like a crash course in everything,” she added. “All the things that we get exposed to there—there’s no other conference, no other training class that you can go to and walk away with as much knowledge as you do when you participate in SCinet.”
Even as a temporary, volunteer-powered network, SCinet does practically everything. “SCinet lays down the fiber at the convention center, it builds all the booth drops for each of the SC members—people like IU, Purdue,” Weilhamer explained. “All the members that participate in the conference, their networking activity, it’s all provided by SCinet.”
The people behind the network form more than a dozen specialized teams each year, managing everything from network security to power infrastructure, routing, logistics and equipment, student coordination, and communications support. The week-long-lived network even has its own HelpDesk and NOC.
Sometimes the volunteers come together from these disparate teams to troubleshoot a problem. The human network behind SCinet is what’s really special, Weilhamer said.
“It’s just tremendous, because it looks like a house on fire and all of a sudden, you can get it back on the rails,” she said.
As part of the Supercomputing conference, SCinet isn’t just a backbone connection for SC members. It also acts as a test lab for pioneering network hardware and applications: It’s the stage for a six-day preview of the future. That’s where Weilhamer and the Network Research Exhibition team enters the picture.
NRE helps computer scientists, researchers, and hardware vendors demonstrate their latest innovations—experiments that could transform anything that uses networks, from the Large Hadron Collider to trans-Atlantic international networks to virtual reality.
Weilhamer also helps researchers network, in the other sense of the word. As a member of the Innovating the Network for Data Intensive Science (INDIS) group, she helps researchers publish their whitepapers and get noticed by the right SC members to take their ideas to the next level.
But it’s not just the research and demos that bring network and computing to new heights at SC. The network itself continually breaks new ground, year after year. And SC16 was no different for SCinet, Weilhamer said.
“One huge thing is the fact that we had the largest push of traffic on the network this year,” she said. “There were 1.2 terabytes pushed from the showroom floor out. That’s the most, ever.”
That’s pretty impressive for a volunteer-powered network with a physical lifespan shorter than a housefly.
“We do plan for a whole year,” Weilhamer pointed out. “Then we stage and set up the network in a few weeks, and everything is normally up and running for four days.” After the conference, SCinet volunteers tear down the world’s perennially fastest network, in less than 24 hours.