In the light of all the discussion about disciplining your child that the NFL has created, I think this is a good time to talk about how to discipline teenagers, since it is very different from how you would discipline a young child.
When disciplining a teenager you need to remember that the actions that you take when your child breaks the rules are actions that will hopefully help your child learn. Parents question how much “rope” to give a child, worrying that there might be too much, and the child will “hang himself.” Other parent’s worry that being too strict will result in their teen rebelling, losing respect, and not loving them. Others consider rebellion and defiance to be “normal” in teenagers and thus may rarely take a teen’s misbehavior seriously. While to some degree rebellion and defiance are natural, it has been found that excessive rebellion and excessive defiance are usually indicators of an oppositional defiant behavior disorder and are not necessarily associated with health.
The problem is that most parents only have the model of discipline that was meted out to them as children and teens. For many, identification with the normal rebellious and defiant aspects of the teenage years has never been normalized by mature growth; thus they either subtly (or not so subtly) stimulate “bad behavior,” only to follow it, in their own anxiety and confusion, by administering punishment to the adolescent. Not surprisingly, this causes the teen perplexity, anxiety, and confusion.
On the other hand, constructive discipline tends to result in the development of a mature young adult by the end of the adolescent passage. It helps a teenager control his impulses, cooperate with other people, and be patient. The aim of discipline should not be to develop a homogenized and completely socialized teenager; parents should always stress the uniqueness of their teenage sons and daughters. Rather, discipline should result in a teen taking a wholehearted and responsible approach to life. Disciplining a teenager is different from disciplining a younger child since the teenager is more mature, more reflective, and more able to enter into discussions and negotiations. This means that discipline can and should always be enlightening to teenagers, never a means of deriding, shaming, or making them feel as if they are “bad.”
What to Do
- Don’t be a cruel parent. Don’t humiliate, criticize destructively, physically attack, or try to cripple your teenagers will just in order to make him conform to certain rules.
- Make expectations and rules clear to your child.
- Don’t be scared to set limits.
- Do not make rules arbitrarily, even if you feel strong about them; they should involve some give and take.
- Understand that whatever teaching and disciplining you do, most teenagers will mature through trial and error.
- Reward constructive behavior rather than criticize bad behavior.
- Be a role model for your teenager.
- Be compassionate and patient when it comes to discussion of family rules and responsibilities.
- When punishing your teenager it is best to withdraw privileges. However, make sure to not over-punish because you are angry.
- Never use physical or mental torture.
- Don’t give in to tantrums or loud and intimidating behavior, and don’t allow guilt to cloud your judgment.
- Remember, teenagers test the limits. You will be tested!
In the end, be compassionate and empathetic and remember what it was like to be a teenager. Your greatest influence on your child doesn’t come through your punishment but through your being a good role model and your ability to understand the situation and act appropriately..