Dynamic security limits the power transfer capacity between regions and therefore has an economic impact. The power modulation control of high-voltage direct current (HVDC) links can improve the dynamic security of the power system. Having several HVDC links in a system creates the opportunity to coordinate such control, and coordination also ensures that negative interactions do not occur among the controllable devices.
This thesis aims to increase dynamic security by coordinating HVDC links, as an alternative to decreasing the transfer capacity. This thesis contributes four control approaches for increasing the dynamic stability, based on feedforward control, adaptive control, optimal control, and exact-feedback linearization control. Depending on the available measurements, dynamic system model, and system topology, one of the developed methods can be applied. The wide-area measurement system provides the central controller with real-time data and sends control signals to the HVDC links.
The feedforward controller applies rapid power dispatch, and the strategy used here is to link the N-1 criterion between two systems. The adaptive controller uses the modal analysis approach; based on forecasted load paths, the controller gains are adaptively adjusted to maximize the damping in the system. The optimal controller is designed based on an estimated reduced-order model; system identification develops the model based on the system response. The exact-feedback linearization approach uses a pre-feedback loop to cancel the nonlinearities; a stabilizing controller is designed for the remaining linear system.
The conclusion is that coordinating the HVDC links improves the dynamic stability, which makes it possible to increase the transfer capacity. This conclusion is also supported by simulations of each control approach.
Due
This paper presents a method for designing a centralized coordinated controller for several HVDC links. The controller increases the damping of the power oscillations by modulating the current through the HVDC links in a coordinated fashion. To design a centralized coordinated controller a reduced order open system model is estimated. The open system model of the power system is estimated using the Numerical Algorithms for Subspace State-Space System Identification (N4SID) algorithm which is a black-box system identification technique. The current set-point change through the HVDC links is the set of input signals and the speeds of the generators are the set of outputs. This controller design method increases the damping significantly, which is shown for a small power system. CIGRÉ Nordic 32-bus system including two HVDC links. The case study demonstrates that accurate low-order state-space models can be estimated and validated by using the described method to accurately model the system's power oscillatory behavior.
This paper deals with optimal coordinated control of several high voltage direct current (HVDC) links based on an estimated model of large power systems. The model of the power system is estimated by using subspace system identification techniques. An optimal controller is designed based on the estimated model with the aim to improve the damping in the system. The main contribution of this paper is the development of a new method which uses global Phasor measurement units (PMUs) signals for coordinated damping control of multiple HVDC links. The input signals are the controllable set-points of the HVDC links, the output signals are the speed signals of selected generators obtained from PMU. The PMU signals are used to estimate the current state of the model, i.e., the state of the system, an appropriate control action can then be applied to dampen the system. The benefit of the method is that the used output signals, i.e., the used PMU signals, are independent of the system equilibrium and therefore makes it possible to use state-feedback control, i.e., coordinated control. The method is applied to the Cigre Nordic 32-bus system including two HVDC links. The consistent results show that the damping can be significantly increased.
QC 20120503.