NAIROBI, Kenya – There is a legend in the Samburu culture of northern Kenya: All animals belong to women, but some were released into the wild many years ago and never came back.
But in recent times, the matriarchal owners of these animals have shied away from their role, fearing or even hating some of their charges, like the lions they would come across on walks to fetch firewood and water, while the Samburu men, known often as warriors, were out herding livestock.
Now a group of Samburu women have tapped back into their maternal pride to become lion defenders, their own warriors in a culture where women’s roles rarely exceed domestic chores. The women’s interest was piqued after seeing men being trained to fight for lions by conservation organization Ewaso Lions. Despite some initial apprehension, the women now doggedly campaign for a program called Mama Simba.
“The women kept approaching Ewaso Lions, coming to camp practically every day saying ‘We’ve seen the warriors doing this. We feel that we could do just as good a job if only someone gave us the opportunity,’ so that was the start of Mama Simba,” Heather Gurd, conservation manager at Ewaso Lions, said.
Mama Simba participants set up their own school, which operates four days a week. (Tyrell Bernardini)
The Mama Simba program started in 2013 by taking more than 30 women from Sasaab village in the Westgate Community Conservancy on safari drives to learn about the environment. Staff then set up a school to educate a small group of women who had never been taught to write even their names.
The women are trained in conservation, including the importance of litter-gathering, how to reinforce bomas – thorny stick-walled enclosures where they keep cattle – to stop predators coming and how to identify and report the tracks of predators. The loss of cattle often leads to conflicts between communities, so women are also taught how to resolve disputes peacefully.
But the weekly lessons held in the village preschool were soon not enough for such determined students.
“They were so passionate about learning that they decided to build their own bush school, so they now have that just on the outskirts of their village which means they can now go four times a week,” Gurd said.
One Mama Simba recruit, Munteli Lalparasaroi, in her 20s, has gone from complete illiteracy to training other women to defend lions. From having barely left her home area, she has crisscrossed Kenya to learn more about conservation in areas such as the Maasai Mara and Lake Victoria.
“Before I was asleep but now I have been educated,” she said. “I am the most lucky Samburu woman to board an airplane, which the Samburu before thought was only for those who went to school.”
Munteli is even more thrilled about learning to drive, because it allows her to spread her conservation message further and make more women lion-loving warriors. “Now I can drive and before I never thought this was possible. It’s like I’m dreaming,” she said.
One of Ewaso’s aims is to change people’s beliefs that lions and other carnivores are a menace and that wildlife belongs to tourists and the government. She wants to replace these attitudes with a sense of local pride in wildlife. “People are learning that wildlife is a good natural resource and that everybody needs to be responsible,” Munteli said.
There are only 50 lions left in the Samburu lands of Kenya, but a determined group of women is fighting to save them. (Biosphoto/Berndt Fischer)
With only an estimated 50 lions remaining in the Samburu-Isiolo ecosystem, women are a great asset for monitoring the population, because they often hear about lions’ whereabouts from other women in the community while men are off herding.
“Having these ladies increases our network of informants about lions, because all the ladies will report back to us if they see tracks around their village or on their way to town they come across lions or they hear from others in the community that there has been a conflict incident,” Gurd said.
From being shut out of conversations outside the home and therefore conservation, the 19 educated and trained Mama Simbas have earned women a say at meetings and a greater level of respect in the community.
“Girls are learning they have a voice in the community as human beings. The ladies can also take part in leadership and governance. Ladies are getting enlightened,” Munteli said.
“They were very shy at the start of the program and we’ve seen a real change in their confidence and the enthusiasm they have,” Gurd said.
She has seen women become spokespeople for lion conservation, passing their ideas on to their children who in turn tell warriors not to kill lions for cultural, ecological, economic or environmental reasons.
When not monitoring lions, the women make and sell beaded figurines or use other craft skills learned in the program to support their families during the dry season, when men migrate with livestock.
“I have learnt a good number of business ideas and can now make money of my own, which is not something that is done so much by any Samburu women,” Munteli said.
But that doesn’t mean that she and the other women aren’t still pushing to know and do more. “I have not yet reached my expectations because I want to ask more and stay with Ewaso Lions so I can read and write very well,” Munteli said.
This article originally contained a reference to Samburu warriors going hunting. This has been corrected to reflect that the Samburu are pastoralists, and instead go out herding livestock.