Listening is given lip service. From the time we are children, we’re told that listening is important – how else are we to gain the wisdom that adults have? Although we are never taught this essential skill, we are held accountable for it even at an early age. I can still see my father’s pointed finger shaking at me with that impending non-verbal warning, “Listen to me, or go to your room!” Author Sandra Collins states, “The role of listening is treated almost like a punishment… we spend most of our time listening while the more powerful, respected, or authoritative figure does all the talking.” Often this feels true in the workplace as well, where bosses give directions, proffer unsolicited feedback and command meetings.
This feels like a disadvantage to those of us who enjoy and choose to connect with others through listening, qualities that are frequently associated with being introverted. Jennifer Kahnweiler describes introverts as those who tend to stay to ourselves, are calm and reserved, and enjoy one-on-one conversations that are thoughtful, rather than superficial. These qualities make us a magnet for people (often extroverts) who are verbally expressive, and easily share themselves and their opinions. It can feel like the workplace favors those who more easily speak out and speak up when you prefer time alone or to think in silence. This is a problem because, as Susan Cain, author of Quiet: The Power of Introverts in a World That Can’t Stop Talking reminds us, introverts comprise between 33% and 50% of the workplace. Despite our numbers, it has been easy to overlook us.
This will change as studies prove that these same qualities that often cause us to seem invisible, can also help to make us good managers. Researchers Ames, Maissen and Brockner found that listening is positively related to influence as it allows one to gather information and build relationships. Sydney Finkelstein notes that employees are happier when they feel like they are being heard and contributing to generating solutions. Additionally, Itzchakov and Kluger’s findings “support existing evidence that managers who listen well are perceived as people leaders, generate more trust, instill higher job satisfaction, and increase their team’s creativity.”
Listening can be challenging under the best of circumstances because we hear 400 words per minute and speak on average 150 words per minute. It’s very easy for our minds to wander, causing us to lose focus. This is especially possible during difficult conversations or times of conflict. Preparing what to say in response, advocating for our own ideas, and defending our position replace listening when our emotions are inflamed. We are so concerned with getting our own points across that our mind is occupied thinking about when we can speak. Ironically, this is when listening is even more critical. We must counter our instincts to avoid conflict, slow down our mind and double-down on our valuable listening ability. So how can we become powerful listeners?
Preparation
- set an intention to be fully present
- ensure you have enough time to listen
- adjust your body so that you’re in a comfortable position
- make direct eye contact (if culturally appropriate)
- eliminate/limit environment distractions such as shutting down your cell phone as well as physical distractions such as your hunger
- write down any questions that you want to ask in advance
- write down any points you would like to make in advance
Listen
- be curious
- notice when your attention wanders and bring it back to focus
- be willing to suspend judgment and to even try on the other person’s perspective
- be aware of confirmation bias (Isaacs, 1999)
- maintain an open posture – lean forward, don’t cross your arms
- do not interrupt
- do not think about your rebuttal
- do not offer solutions
- when the speaker stops talking ask, “Is there anything else?”
When it is time for you to speak you will have taken the steps necessary to increase the likelihood that you will feel heard. You will have set a stage on which trust is built and, as Nancy Ancowitz, author of Self-Promotion for Introverts recommends, you will have prepared beforehand so that you can get ahead of any potential obstacles to communication. Because introverts like to process information before we reply, if you need time to think, Seppala and Stevenson suggest saying, “I haven’t thought about it that way before. Can you give me a day or so to think it over?” This will give you the desired time to reflect and evaluate. Alternatively, if you need a break, it’s okay to ask for one. Another option Kahnweiler suggests is “Walk and Talk,” saying, “Introverts tend to respond to the relaxed pace and walking beside people, rather than intensely interacting head-on, as can happen in heated discussions.”
If your ultimate goal is to hear and be heard that doesn’t mean you have to speak the loudest. Listening may be the quietest, yet most impactful, thing you can do.
Dr. Nancy Goldman combines her experience working in the entertainment industry with her doctoral studies in adult education to teach business leaders how to communicate with impact and influence. Dr. Goldman is faculty at both of her alma maters, Columbia University’s Teachers College and New York University. Her interests and background are at the intersection of arts, education and business. In addition to over a decade of experience working in television, Nancy has managed New York City’s top comedy clubs, hosts storytelling home concerts and has worked on Wall Street, in non-profit, and government. She has designed and delivered programs in leadership communication skills, applied strategic communication, creative thinking and career development for organizations such as MIT Sloan School of Management, Barnard College’s Athena Leadership Lab, Producers Guild of America, The Actors Fund and Sponsors for Educational Opportunity.
Nancy has a Doctorate in Education as well as a Master’s in Organizational Psychology and a Master’s in Communication and Computing Technology from Columbia University’s Teachers College. She lives in Queens, New York with her honey, bird and cat.