Can We Please Retire the Word “Problematic”?: A Plea for Using Precise Language
If you spend any time on the bookish internet, then you’ve heard the term “problematic” applied to books. Books are deemed problematic for all sorts of reasons: transphobic language, blatant racism, cultural appropriation, harmful and/or offensive tropes or stereotypes, ableism. I am 100% in favor of pointing these things when they appear in books. Authors from non-marginalized communities (especially white authors) writing about characters from those communities have gone uncriticized for far too long. It is a win for readers everywhere that more and more people are speaking up about racism, transphobia, sexism, and other -isms as they show up in literature. We’re never going to fix it if we don’t talk about it. But, respectfully, may I please request that we all retire the word “problematic” from our vocabularies?
I don’t want anyone to stop talking about the ways in which authors fall short. I’m just tired of the word itself. Problematic doesn’t actually mean much anymore. I’d argue that the term has mostly become a tool of virtue-signaling, rather than a useful way to engage with literature and relay critical information about a book.
Most reviewers (especially own voices reviewers and people from marginalized communities) follow a claim that a book is problematic with a list of reasons. A review that starts with the word “problematic” will morph into a thoughtful and detailed explanation of how a book by a white author appropriates Native culture in harmful and offensive ways. But we all know what internet culture is like: fast-moving and not overly concerned with details. After seeing the word “problematic” signaling that a book has done something wrong, how many people read the much more important substance of the review?
I don’t know the answer, and I don’t have any data to offer. But I do know how easy it is to skim over things on social media without actually engaging with them. If I see the word “problematic” and immediately categorize that book as “don’t go near it,” what have I learned? I don’t know if the book is deeply, irrevocably terrible, or if the author has made some misguided choices they might learn from and address in future works. If it’s a popular book that I know a lot of people will be reading, I haven’t gained any new knowledge that will help me explain to others why I’m not recommending it. Knowing a book has been dubbed “problematic” doesn’t provide any useful tools for me as a reader, reviewer, or citizen of the bookish world.
I want to know if a book is transphobic. I want to know if a book badly misrepresents queer people, and if so, how. I want to know if a book contains unnecessary racial slurs. I want to know if a book’s plot relies on a white savior narrative, or perpetuates harmful stenotypes about disabled people, or uses mental illness as a “plot twist.” I want to know if the only Black character is a loud, “sassy” woman with no agency of her own. These are problems I’ve seen over and over again in books, and they’re worth noting, both as a warning to readers who may want to avoid those books, and in the hopes that, by calling them out, authors will pay attention, and do better.
So why bother using the word problematic in the first place? Obviously, racism is problematic, but it’s more than just that — it’s racism. I don’t see any reason to preface a statement that a book perpetuates racism in x, y, and z ways with the “problematic” label. Problematic is a catch-all phrase that allows readers to signal they’re some kind of woke. But it doesn’t leave much room for nuance, and it’s not a useful way to make publishing more just and inclusive. And isn’t that why so many of us bother pointing these things out, especially in the work of authors we love? I am always working to be a more thoughtful and observant reader. Humans are fallible and imperfect and make a lot of mistakes. When I criticize a book, it’s because I want that author to do better. I want other authors to learn from that author’s mistakes. I want to get to a place where everything that currently falls under the “problematic” umbrella is simply no longer tolerated, because enough of us have been loud enough to make authors, editors, and publishers understand that if a book is racist, or ableist, or transphobic, or Islamophobic, it won’t sell. I know. We have a long way to go. But that’s why I’m out here using precise language while shouting about books.
It’s easy to say a book is problematic, and it’s easy to feel good about yourself afterward for noticing. It’s a lot harder to pinpoint exactly what it is about a book that’s a problem. And it’s much scarier (especially, I’d imagine, for people of color, trans people, and others who are more likely to be attacked on the internet for telling the truth) to call a book’s problems by their names than it it is to just wrap the whole thing in the vagueness of “problematic.”
I know that dismantling systems of oppression —in publishing or literature or anywhere — is lifelong work. But if all of us readers who care deeply about the world and each other, who crave inclusive, thoughtful stories and who believe in uplifting all voices, speak up precisely and carefully when an author doesn’t get it right — well, that’s a place to start.