
Treating obesity and Type 2 diabetes
Weight loss surgery as a standard of care for Type 2 diabetes and obesity has taken a major step forward following the release of a landmark position statement from the International Diabetes Federation (IDF).
Figures from IDF state that there are currently 285 million people with diabetes worldwide, which is set to rise to 438 million by 2030. This astounding figure, driven by the global problem of growing waistlines, has led to a detailed review of the role of bariatric or weight loss surgery – a series of procedures such as adjustable gastric banding (Lap-Banding) and gastric bypass performed on people who are obese.
Monash University’s Associate Professor John Dixon and Professor Paul Zimmet, also from Baker IDI Heart and Diabetes Institute, were part of the four global leaders who chaired the consensus group.
Supported by a group of public health, diabetes, health economic, obesity and surgical experts, the group found that clinically severe obesity is a complex and chronic medical condition which can be substantially improved with conventional bariatric surgery.
Professor Dixon said, “Type 2 diabetes is a varied and complex disorder and, while all its causes have yet to be fully explained, weight gain and obesity are considered the primary risk factors.
“The dramatic rise in obesity and diabetes has become a disastrous global public health crisis and demands urgent attention from governments, healthcare systems and the medical community,” said Professor Dixon.
The expert group combined the available evidence for efficacy, safety and cost-effectiveness of the established bariatric procedures, comparing it to current standard therapy for people with obesity and Type 2 diabetes.
After exploring the effects of bariatric surgery, the consensus group found that the procedure could improve glycaemic control and other obesity-diabetes related conditions.
“In the majority of patients treated, the Type 2 diabetes appears to remit completely. Although we see no active clinical evidence of the disease we do not call this a cure but a remission,” said Professor Dixon.
The research findings indicated that bariatric surgery can provide an appropriate treatment for people with Type 2 diabetes and obesity who are not achieving recommended treatment targets with medical therapies, especially in the presence of other major cardiovascular risk factors and obesity related diseases.
“Bariatric surgery should be incorporated into standard Type 2 diabetes treatment programs. The establishment of national bariatric surgical registries is also recommended,” said Professor Dixon.
The position statement found that various types of bariatric surgery, originally developed to treat morbid obesity, constitute powerful options to improve diabetes in severely obese patients. This often normalises blood glucose levels, reducing or avoiding the need for medications and providing a potentially cost-effective approach to treating the disease.
“Continuing research is essential to prevent the onset of obesity and Type 2 diabetes. At the same time, effective treatment must also be available for people who have already been diagnosed – for many surgery is the most effective therapy,” said Professor Dixon.
Over his 13 years at Monash Professor Dixon has had a major role in research into the effects of bariatric surgery on health, including conducting the first, and to date the only, high level randomised controlled trial comparing conventional therapy with surgery as a treatment for diabetes. Monash University has led the world in this area of research.