Publishing Target Types
In Project Settings, you can create new or select existing publishing targets to publish your content from your projects. There are several publishing target type options to choose from, including:
- Institutional Collection in Artstor, home to the Artstor Digital Library and a platform with various tools for use in teaching
- Personal Collection in Artstor, a collection that’s only accessible by the collection owner, but can be shared through image groups and folders
- Public Collection in Artstor, content will display in Artstor, but is freely accessible to any user without logging in.
- Omeka, a locally-hosted or Omeka-hosted website used in creating online exhibitions
- OAI, an Open Access Initiative Protocol for Metadata Harvesting (OAI-PMH) server that makes your content discoverable on your library’s discovery layer
- JSTOR Community Collection, publish open access or institutional collections on JSTOR with your own institutional landing page and individual collection pages.
Edit Publishing Targets
Once a target has been created for an Institutional or Public collection, you can edit the collection name, description, add a collection representative image, and enable clustering support. For any publishing target type, you can also edit the download size, collection right statements, and select or deselect the target as your default target for the project.
To edit an existing target:
- Under the Targets tab, select the publishing target you wish to edit, then select Edit.
- You may make changes to:
- Collection Name* - edit a collection name.
- Collection Description* - This description appears in Artstor above your collection to offer additional context.
- Description character limit is 1,000 characters, and it can be edited at a later time.
- You can include hyperlinks in your Collection Description using the following code in the text of your description:
- <a target="_blank" href="The URL that you want to link to" style="display:inline">Enter the text that you want to hyperlink here</a>
EXAMPLE: <a target="_blank" href="" style="display:inline">JSTOR Forum</a>
- Collection Image - This 240 by 240 pixel JPG or PNG image displays next to the description. Some examples of the collection image include an institution's logo or an image from the collection that represents the content.
- Maximum Image Download - Set the maximum download size from Artstor. Options include Download not allowed, 400 pixels (JPEG), 1024 pixels (JPEG), 3000 pixels (JPEG), and Maximum download size (JPEG).
- Default Target - Set this target to be a default target to publish to from your project.
- Cluster Items Linked to Works (Institutional or Public Collection in Artstor only) - If using work records, check this box so items linked to works display together as a cluster when the collection is browsed. For more information, consult Link Items to a Work & Publishing Works.
- Collection Rights Statement - This statement will be added to each item published to this target. Consult Collection Rights Statements for more information. Also know you have access to RightsStatement.org and Creative Commons Licenses for providing rights information to items.
- Save the changes. For institutional, public, and personal collections in Artstor, please republish any items that were published prior to making changes to your publishing target.
*This only be done for JSTOR Community Collections and Artstor Institutional or Public Collections.
Remove a Publishing Target
To remove a publishing target from a project, you first need to suppress all items published to that target from that project.
To remove a publishing target, suppress or delete all items published to the target you want to remove in Forum. In Project Settings, navigate to the Targets tab and select the publishing target you want to remove, then select the trash can icon.