Two weeks ago, at Mulago Hospital in Kampala, I sat down next to a mother called Sylvia, resting in bed with her newborn baby after a successful delivery, nearly ready to return to her husband and five older children.
But I also looked through a window into a room containing eight babies, none more than two days old, their little cots covered in malaria nets. The doctors explained to me that in each of these cases, and hundreds more like them in the same hospital each year, the mother had died in childbirth.
The causes of death varied from bleeding and infection to high blood pressure and failure to survive a Caesarean section – all so easily preventable by modern western standards. In Britain, for the same reasons, the death of a mother in childbirth was once a common hazard, a fixture of Victorian life.
Improvements over the past century in antenatal care, health education, and obstetric and gynaecological care have lowered the risks of childbirth. There may be more to do at home, particularly on the health risks to newborn babies. But nowadays, only seven in 100,000 women die when giving birth in Britain.
In sub-Saharan Africa, the conditions and health care for mothers in childbirth are often no better, and sometimes far worse, than we had in Victorian times. In 1987, more than 500,000 women were dying in pregnancy or childbirth every year across the world, 99 per cent of them in developing countries. More than half of all women were delivering their babies with no skilled birth attendant present.
It was because of this terrible toll that 20 years ago, the Global Safe Motherhood Initiative was launched by the World Health Organisation to try to reduce the rates of maternal death. In 2000, the United Nations recognised the shocking rates of maternal death and made their reduction one of the Millennium Development Goals. The fifth MDG committed the wealthiest nations to cut maternal mortality by three-quarters between 1990 and 2015..
Visit hospitals in Africa and it is easy to see why. While the Commonwealth Heads of Government Meeting was going on in Uganda, I visited labour wards and delivery rooms at Muhimbili Hospital in Dar es Salaam and Mulago Hospital in Kampala. They are both huge referral hospitals attracting many women from across each city, and they offer the only real emergency obstetric care in their areas.
Mulago alone sees the delivery of 33,000 babies a year, almost one hundred a day. Compare that to the Edinburgh Royal Infirmary where my children were born, which is considered a big UK facility and where just 6,000 babies are delivered each year.
In all my visits, I saw overstretched services at work, committed teams with too few con sultants, nurses and midwives, and insufficient equipment and technical provision. Shortages included basic supplies such as sutures and painkillers, which run out whenever there is an extra-busy day for Caesarean sections or other emergency procedures.
The governments in Tanzania and Uganda are doing their best to make progress.
The Tanzanian president, Jakaya Kikwete, told me this was a personal passion for him, and that his government had pledged to put dispensaries around the country that could also offer antenatal care. In Uganda, I saw the nearly completed refurbishment of a maternity block in the Mulago Hospital grounds. But still the death toll remains stubbornly high.
And.
Avoidable deaths
It is obviously harder for a child to survive, grow and have a life with choices if there is no mother to provide care, food, protection and education. The statistics bear this out. A study in Indonesia showed that 14 per cent of children aged six to ten who had lost mothers dropped out of school, compared to only 7 per cent of those who had not. Poverty as an adult was far more likely for the former group.
The same study showed that children without mothers were four times more likely to die in their early years – usually of malnutrition or disease – compared to other children.
Internationally, pressure is growing, through the White Ribbon Alliance, a global campaign group dedicated to highlighting the avoidable tragedy of maternal death, supported by the WHO’s Making Pregnancy Safer campaign and the Partnership for Maternal, Newborn and Child Health. In the UK, the White Ribbon Alliance is led by the Royal College of Obstetricians and Gynaecologists (RCOG) and I sit on its international advisory group. This has given me the opportunity to meet some of the world’s leading experts in this field. It has opened my eyes to the impact of maternal death on the life chances of infants.
The general causes are well understood: high fertility rates lead to greater pressure on resources, inadequate and inaccessible health care makes childbirth inherently risky, and women’s low status economically and culturally affects their access to health services and the priority they are given.
There is also broad agreement on the solutions required: greater resources, better education, better access to emergency care, availability of antenatal care to spot problems in advance and quick referrals for mothers with complications.
The RCOG International Office has designed a course teaching young consultants essential obstetric and newborn care. The course is available in Tanzania and Kenya, and I hope it will soon be extended to Uganda. Accompanied by Tony Falconer, RCOG senior vice-president, I met a young doctor in the antenatal clinic at Muhimbili Hospital who had completed the course two months before, and thought his training had already helped him save lives.
The RCOG is taking this work further. In South Africa, it is working to help obstetric experts develop a training package for all local doctors in their third postgraduate year, generally spent in more remote conditions. Momentum is building. I am hopeful that a special session will be devoted to maternal death at next year’s international summit in Davos and the Bill and Melinda Gates Foundation is funding projects around the world to raise awareness.
At home, just over a month ago, the International Development Secretary, Douglas Alexander, announced at a conference in London that the UK would commit an extra £100m towards improvements in reproductive health. To meet any of the Millennium Development Goals, we need the will, the means and the momentum. We have seen this in relation to vaccinations, free education and the fight against Aids. Now we must see it on the issue of maternal death, where no significant progress has been made, not just in the past seven years, but in the past two decades.
Each developing country needs a strategic health plan that takes account of local situations, expanding services so that populated central and remote areas alike acquire trained people and resources. The investment needed to improve maternal health is small, but the gains for the poorest children in the world will be huge. We must make 2008 the first year of progress on this neglected Millennium Development Goal.
Sarah Brown sits on the international advisory board of the Royal College of Obstetricians. As founder of the Jennifer Brown Fund, she has been closely involved for the past six years in the area of infant and maternal health