Once again an election in Ghana seems to have gone off well. The country’s famed two-party electoral system appears in reasonable health. Incumbent president John Mahama has been voted back in, giving the National Democratic Congress (the Jerry Rawlings vehicle) a second term. Nana Akufo-Addo, the candidate of the New Patriotic Party (which backed two-time president John Kufuor), has been defeated despite attracting nearly 48% of votes. In short, both parties had substantial success but voters opted to give the NDC a second four-year period in office – what Ghanaian parties have come to expect.
Of course, there are claims that the voting was unfair. Even so, it is hard to disagree with President Mahama’s statement, as quoted recently in a Kenyan newspaper: ‘Over the past 20 years, Ghana’s democracy has become a beacon of hope for the entire African continent and in the process, drawn useful lessons for the rest of the world’.
Because this seems so obviously right, and because Ghana is also registering very fast economic growth, this may appear a knock-down argument for the UK’s current foreign policy mantra: poor developing countries need liberal-democratic capitalism, and they need it now.
But hang on a second. The ‘beacon of hope’ metaphor is attractive but even as a judgement on Ghana’s development prospects, it is a bit overblown. And what it says about the rest of the world is seriously inconsistent with the best comparative evidence.
Journalists writing about Ghana are rightly concerned by the storm-clouds forming around the country’s prospective oil boom. Will Ghana be a country where oil wealth proves to be a curse, or one whose institutions are robust enough to turn it into a blessing?
Research by Lindsay Whitfield of Roskilde University provides a solid basis for speculation on this subject. According to this work, Ghana’ competitive but highly clientelistic politics impacts negatively on the prospects for achieving real structural change and upgrading in the national economy. Competitive clientelism has combined with a weak indigenous capitalism and the availability of easy finance from aid to give political leaders an extremely short-term time-horizon. Policies geared to the long-term economic needs of the country are of little interest to them. Consequently, entrepreneurs with the potential to accumulate capital and technological capabilities in productive activities are systematically discouraged from doing so. So even for Ghana, the Ghana model has its problems.
The other reason for caution is the commonplace that institutions have different effects in different contexts. Two-party competitive politics may find a welcoming environment in Ghana, but that does not mean it can be exported just anywhere. It is surely no accident that other African countries have adjusted the institutional templates inherited from their colonial masters in very different ways. Of course, nearly everywhere we now see electoral contests that are in principle free. But the actual functioning of these systems varies hugely (just take the very different examples of Kenya, Malawi, and Mozambique). It does not seem to be an accident that these countries’ systems differ from each other and from the Ghana model.
What then accounts for the friendliness of the Ghanaian environment to the institutionalisation of a two-party system? There isn’t an easy answer, but a rich literature now exists on the more general question of how the functioning of institutions is shaped by context. The excellent recent sequel to Violence and Social Orders by Douglass North and team focuses on how different forms of ‘limited access order’ avert the threat of internal war by sharing out rents among powerful elite groups. The basic idea is that the fundamental power distribution in society determines what institutions work and how they work.
In the spirit of that theory, a key aspect of the Ghana story is a distinctive historical trajectory that has given Ghana a unique sort of fundamental power distribution among elites, one that is based on an understanding between two large blocs. In that context, it makes sense to all concerned to share access to rents by having political parties alternating in office. In countries with other social and economic structures, access to rents is more naturally shared among elites through some other arrangement – perpetually recomposing ethnic coalitions in Kenya; a single dominant party in Mozambique; a highly fluid presidential following in Malawi.
For sure, each one of these political modalities has shortcomings from the point of view of developmental political leadership. They are all in need of radical changes to make them better drivers of processes of sustainable structural transformation. But the changes that might work in this sense have to start from where each country is, not from where it might wish to be. Successful reforms will be less likely if the assumption is made that there is a unique beacon of hope, represented by Ghana.