LimeSurvey is one of the many open source survey applications written in PHP, and uses a MySQL or PostgreSQL database. LimeSurvey is a user-friendly web application that allows users to develop, publish and collect responses to surveys. Users can use rich text in questions and messages using a rich text editor, and images and videos can easily be integrated into surveys. Surveys can be public, or can be strictly controlled through the use of ‘once-only’ tokens for each survey participant.
This installation guide should work on any Debian based Linux distribution as well, but was tested and written for an Ubuntu 14.04 VPS.
At the time of writing this tutorial, LimeSurvey 2.06 is the latest stable version available and it requires:
– Apache web server.
– PHP (version 5.3.3 or later) with mbstring extension library and PDO database driver enabled for MySQL (pdo_mysql / pdo_mysqli) or pdo_pgsql for PostgreSQL database.
– MySQL(version 4.1.0 or later) or PostgreSQL (version 8.1 or later) installed on your Linux VPS.
Installation instructions:
Log in to your VPS via SSH:
ssh user@IP
Update the OS packages:
[user]$ sudo apt-get update && sudo apt-get -y upgrade
Install MariaDB:
To install MariaDB, run the following command:
[user]$ sudo apt-get install -y mariadb-server
Create a new database for the LimeSurvey installation:
[user]$ mysql -uroot -p MariaDB [(none)]> CREATE DATABASE limesurvey; MariaDB [(none)]> GRANT ALL PRIVILEGES ON limesurvey.* TO 'limeuser'@'localhost' IDENTIFIED BY 'your-password'; MariaDB [(none)]> FLUSH PRIVILEGES; MariaDB [(none)]> \q
Do not forget to replace ‘your-password’ with a strong password.
Install Apache2 web server:
[user]$ sudo apt-get install apache2
Install PHP and required PHP modules:
To install the latest stable version of PHP version 5 and all required modules, run the following command:
[user]$ sudo apt-get install php5 libapache2-mod-php5 php5-mcrypt php5-mysql
Download and extract the latest version of LimeSurvey to your server:
[user]$ sudo cd /opt && wget [user]$ sudo unzip limesurvey206plus-build151014.zip [user]$ sudo mv limesurvey/ /var/www/html/limesurvey/
LimeSurvey needs certain access to ‘tmp’, ‘upload’ and ‘application/config’ directories within the ‘/var/www/html/limesurvey’ directory. This can easily be accomplished by running the following command:
[user]$ sudo chown www-data:www-data -R /var/www/html/limesurvey
Create a new virtual host directive in Apache. For example, create a new Apache configuration file named ‘limesurvey.conf’ on your virtual server:
[user]$ sudo touch /etc/apache2/sites-available/limesurvey.conf [user]$ sudo ln -s /etc/apache2/sites-available/limesurvey.conf /etc/apache2/sites-enabled/limesurvey.conf [user]$ sudo nano /etc/apache2/sites-available/limesurvey.conf
Then, add the following lines:
<VirtualHost *:80> ServerAdmin admin@yourdomain.com DocumentRoot /var/www/html/limesurvey/ ServerName your-domain.com ServerAlias <Directory /var/www/html/limesurvey/> LimeSurvey installer should start. Follow the easy instructions on the install screen inserting the necessary information as requested.
Once you finish the installation, access the admin section at:
A good way to start using LimeSurvey is to read the official user manual available at:
Of course you don’t have to do any of this if you use one of our Managed Ubuntu Hosting hosting services, in which case you can simply ask our expert Linux admins to install LimeSurvey for you. They are available 24×7 and will take care of your request immediately.
PS. If you liked this post please share it with your friends on the social networks using the buttons on the left or simply leave a reply below. Thanks.
1 thought on “How to install LimeSurvey on an Ubuntu 14.04 VPS”
Needs to be updated as times have moved on. With a lot of work arounds, I did successfully navigate the current process based on this old map.