Sara Gardner, MPH
Executive Director.
Social circumstances, environmental conditions, genetics, and behavioral choices (and how they intersect) account for the remaining 80 to 90 percent. Looking at this math, it makes absolutely no sense that we are spending the majority of our health-directed resources—some say 97 percent—on health care. That’s close to three trillion dollars. And we still rank 27th in the world in life expectancy and relatively low on many other health and wellness measures—not a great return on investment. Enter public health.
Public health is the science of promoting and protecting the health of people and their communities. Public health is prevention from sickness and injury. Public health creates environments where the healthy choice is the easier choice and nudges people toward healthy behaviors. It’s research for disease control and injury prevention and development of sound policies and regulations to keep us safe and to support well-being. Public health focuses on entire populations and affects everybody. Think this is solely the work of government officials and scientists? Think again. Public health is everybody’s business, and we all have a part to play.
In our current environment of health care reform, public health is repositioning itself at the national, state, and local levels to focus on the social determinants of health. Social determinants of health are conditions in the environments where we live, work, play, and learn. They affect a whole range of health and quality of life outcomes and risks and include access to education, jobs, and transportation, as well as social norms and attitudes. When we address these social determinants of health, the return on investment is significant.
With the lion’s share of investment in health going to clinical care, the social determinants of health—80 to 90 percent of what matters—goes underfunded. The private sector can and should play a crucial role in readjusting this balance, not only for the good of society, but for its own bottom line. Businesses are finding that corporate wellness programs save money on health care costs. Funding community-based and government-led efforts for wellness will save even more.
The Nurse-Family Partnership is a national nurse home visiting program committed to improving the health, well-being, and self-sufficiency of low-income, first-time mothers and their children. Specially trained nurses coach, educate, and listen to their clients and provide the support they need for healthy pregnancies, to competently care for their children, and to become more economically self-sufficient. Studies have shown an estimated $9.59 return on every dollar invested in this community-based initiative.
Another public health initiative, the Diabetes Prevention Program, helps people who are at risk for type 2 diabetes make lifestyle changes—eating better and exercising more—to reduce their risk of becoming diabetic. This program averages savings in health care costs from $4,250 to $6,300 per participant over 10 years.
This movement to focus on the social determinants of health requires nontraditional collaboration, participation, and investment across sectors. Government agencies and their nongovernmental partners must work together to address the conditions within the communities they serve through efficient and accountable processes. When the private sector invests in public health initiatives, innovation and entrepreneurial spirit animate the work. With more investment in preventive, upstream efforts, we can transform our current system of sick care to a system that nurtures health.
We must reevaluate how we invest in “health.” This new commitment starts with strategies and evidence-based action that will prevent disease and cut health care costs rather than attempting to “buy it back” when we are sick. Public health is an often misunderstood, underappreciated, and most definitely underfunded discipline which holds the key to bring down health care costs and elevate human health—our most precious commodity.