.
I was also asked a similar question in relation to the future of security and technology by a senior executive (no free lunch there) and spent some time bringing together many of the trends and changes I’ve been watching. Now the business context for this was for a big global conservative enterprise, that means trends which are passe in startups are still just starting to gain ground. I’ve used this quote recently “The future is already here — it’s just not very evenly distributed.” from William Gibson but he remains entirely relevant. Some of what I am going to describe is already here in earlier adopter organisations but some of it I haven’t seen yet although invariably Netflix have already done this for themselves.
I’ve spoken before about my growing cynicism regarding the cyber skills shortage:
How much is the security skills shortage actually a lack of automation forcing skilled practitioners to spend time on manual grunt work?
— Phil Huggins (orac) (@oracuk) September 22, 2016
Automation has the potential to significantly address what we are perceiving as a skills shortage as well as improving our response times and as a result limiting damage. I am suspicious of the machine learning/AI algorithmic utopia that vendors are selling, partly as a result of real limitations in the techniques but mostly due to the closed and black box implementations that mean we will have many many machine-learning driven controls that don’t talk to each other and don’t learn from each other. Reductive security fails in the increasingly complex socio-technical systems we are building.
I do see a near-ish future where automation, big data, devops, chatops and machine learning (I need to get social media and mobile into this list somehow) will combine into a more cohesive approach to security.
At the core is a data lake, a large format-agnostic bucket for log data and databases of all types. With that is a series of processing and integration capabilities that not only allow on-boarding and parsing of the various data sources but also a series of composable analytics that allow small insights to be combined into larger more intelligent analysis. Building on that analysis is an automation engine that uses a combination of hand-coded and machine generated ‘rules’ for taking actions using APIs across the technology estate. Sometimes those rules will be a ‘ask for human decision’ action which will reach out via natural language chatbots to the appropriate security teams for a decision. Similarly the chatbots will have the ability to request API actions on behalf of their (appropriately authenticated and authorised) communities with which they converse. Different communities cluster around persistent chat channels to interact with each other, with the chat bots and ultimately ‘observe, orient, decide, act’ with as few context shifts to different web interfaces as possible.
That is a very dense paragraph and hopefully the diagram below shows at a high level what I think we need to achieve:
The different communities cluster around existing skills and workflows where security teams interact with other teams. The most mature example would be a development community where the security architects and the developers collaborate across an automated build, test and deploy pipeline as shown in more detail below. This is the most mature of these communities and variations of security-integrated automated pipelines in devops organisations are already effective:
The area that is ripe for exploiting this approach, short on skilled staff, needing faster response times, data-driven …. is the security operations community. There are already good mature tools in the SIEM space and improving tools in the TIP space such that I don’t see these being absorbed by the Security Core immediately although it will become clear over time that what they really are is a specialised parsing and alerting engine that could be incorporated with some engineering effort. Key to this community is the Controls APIs, without effective APIs for automated security control configuration this will never work. Some vendors do get this but many still produce after-thought grudging APIs. This will become a key part of options analysis and PoCs in the near future. If we have to employ more people to push more web interfaces then your tool ROI is going to drop dramatically.
The community that have barely been touched upon to date apart from some very clunky and painful GRC ‘platforms’ is the Business & GRC Community, I am excited by the opportunities that chatbots using natural language can deliver for security in these communities. I would estimate (wildly based on assumptions) that 80% of application security specialists and security architects work is information gathering from non-specialists, translating non-security relevant descriptions into consistent and comparable models of the security of the systems in question before the 20% of value is delivered which is the identification, analysis and remediation of potential vulnerabilities and risks. I see a future where most of the initial data gathering and re-framing is done by chatbots trained for the purpose and that the models are built automatically and enriched with data from production systems, from the live data in the operations community and the future data from the development community allowing the analysis to be well-informed and coherent across an environment. No more vagaries of the obsessed architect and no more assumptions about future releases or the state production systems leading to ‘impossible to predict’ breaches.
So there it is, my bold prediction for the security fabric of enterprises, I think most are nowhere near ready to do this, I think most vendors haven’t seen the broader picture yet but this is the direction we as a discipline have to go. I’m sure there are many other things I’ve missed (perhaps I could squeeze mobile and social media into some sort of human security prediction?) but at the core this will be necessary to make effective use of the skilled resources we have without squandering their time on spreadsheets, web interfaces and email chains.