The Most Toxic Towns in Rhode Island
Thursday, April 12, 2012
Much of the locally based pollution sources are old landfills, textile mills, industrial buildings, and other hazardous waste sites that were contaminated before modern environmental laws took effect, according to Eugenia Marks, Senior Director for Policy at the Audubon Society of Rhode Island. (See below for the complete breakdown.)
The turning point for environmental regulation was four decades ago—in the early 1970s, when the landmark Clean Water Act and Clean Air Act were passed, along with a slew of other environmental reforms. Rhode Island, along with the rest of the country, has come a long way since then, but it is still paying the price for the sins of the past, Marks said.
GoLocalProv examined five local sources of potential toxic pollution: hazardous waste sites, active and closed landfills; leaking underground storage tanks; businesses like incinerators and chemical manufacturing plants that produce toxic chemicals; and businesses that have a permit to release bacteria and toxic chemicals into waterways within certain limits. Data for each was culled from various databases maintained by the state DEM, the EPA, and other sources. (See below for more information.)
The Communities at the Top
The communities with the highest concentration of toxic pollution sources are also the most urbanized areas of the state. Central Falls found itself at the top of the list, followed by Providence, Pawtucket, and Woonsocket. But there are notable exception of rural communities that neared the top of the list, including Warren and Middletown.
It’s no coincidence, she said, that higher rates of diseases like diabetes and asthma are also concentrated in the same places.
“We know that health and environment go hand in hand,” Rose said. “That’s why it’s so important that protections be put in place so that every community can enjoy a healthy environment.”
But toxic sites aren’t concentrated in the cities only. Rose, a former state organizer for the Toxics Action Center, said toxic sites line some of the state’s water bodies, reflecting a historic use of water by textile mills. The mills may no longer be running, but businesses like wastewater treatment plants and boat yards to be closer to the water. And in Providence, the scrap metal businesses along Allens Avenue are one of the major potential sources of pollution in the city, according to environmental advocates.
Pollution Sites: What is the risk?
The toxic sites listed below pose varying risks to public health and the environment.
“We have a lot of risks in life and this is one of them,” Rose said. “It is something to be concerned about.”
But even if an accident occurs or a rule occurs at one of the toxic sites, the level of risk to the public can only be assessed by determining on a case by case basis how people would become exposed to the toxic chemicals, according to John Torgan, director of ocean and coastal conservation at the state chapter of the Nature Conservancy. “Just the presence of toxic substances doesn’t mean there’s a public health risk,” Torgan said.
Toxic Tanks to Lethal Landfills
Sources of toxic chemicals range from leaking underground storage tanks hidden from view to that eyesore of an old landfill. Below are the five categories of toxic sites reviewed in the GoLocalProv toxic towns ranking:
■ Businesses that produce or release toxic chemicals: These are businesses that are in the national Toxics Release Inventory, also maintained by the EPA. The database tracks businesses—which are required to report such things—that use, manufacture, treat, transport, or release 650 various toxic chemicals. The category is far broader than the water dischargers and includes potential pollution from air emissions, releases into the ground, and underground injections as well as surface water discharges. The inventory can be accessed online here.
■ Superfund sites: Since the 1970s, the word “Superfund” has become virtually synonymous with hazardous waste sites, although the term technically refers to sites that have been identified as serious enough to warrant the EPA getting involved to clean them up and find those responsible for the contamination. There are degrees of seriousness—the most toxic Superfund sites are on the National Priorities List. As of 2008, there were a dozen NPL Superfund sites in Rhode Island—within three miles of more than 115,000 residents, according to the Toxics Action Center. But the total number of all Superfund sites is currently just shy of 150. Click here to view the EPA database.
■ Leaking underground storage tanks: Known as LUSTs, these hidden dangers are most commonly associated with gas stations. It wasn’t until the 1980s that the country woke up the hazards of broken and poorly insulated tanks contaminating the surround environment. According to the last count by DEM, there were approximately 1,700 LUSTs in Rhode Island as of 2006. The state has a fund to help businesses repair or upgrade their tanks, but the review commission that reviews businesses applications has a $1 million backlog, according to Paul Beaudette, one of the members. The threat of contamination from an underground storage tank is very much a real one: in the early 2000s, a leaky tank at a gas station in Burrillville released toxic BTEs in the aquifer which served as the drinking water for residents. (BTE stands for benzene, toluene, and ethylbenzene compounds.)
If you valued this article, please LIKE GoLocalProv.com on Facebook by clicking HERE.
Related Articles
- The Top 20 Biggest Polluters in RI
- Rhode Island’s Most Polluted Lakes
- Using Pollution to Make Clean Energy
- Accused Polluter Contributes Thousands to Top RI Politicians
Follow us on Pinterest Google + Facebook Twitter See It Read It Share It