Article
St. James’s Father Ryan Is a Spirited Voice for Change
Image: William Anthony.
{page break}
On a day in April, Father Ryan relaxed in an armchair in his cathedral office, occasionally putting his foot up on the coffee table, then thinking better of it and putting it back down. Sporting his weekday duds—a sweater, button-down shirt, and trousers—he looked more like an English professor than a Catholic priest. He was quick to laugh and seemed calm, collected. Peaceful in a way that a man who’s on speaking terms with God might be. Though he finds himself at the intersection of politics and religion—and not in lockstep with the Vatican—he proceeds with the confidence that he’s in sync with his congregation.
“I don’t think I’ve ever gotten a response on this scale,” he said of the feedback he’s received following his Referendum 74 announcement. Some 300 emails, another 30 snail-mail letters, and about “95, 96, 97 percent have been supportive.”
Still, “I’ve had some angry responses,” Father Ryan noted, “and I take those seriously. I don’t want to divide the community.” One parishioner said she would leave St. James because of it. “I felt badly about that,” he said. But in the end, “I think we read the community right and did the right thing. I have no regrets.”
“I’m loyal. But that doesn’t mean I can’t step out and ask questions and raise issues.”
This wasn’t the first time Father Ryan has spoken out against a dictate in the Catholic Church. In late 2009, as the Vatican was finalizing a new, more literal and controversial translation of the Roman Missal—the ritual text of the Mass used around the world—the St. James pastor launched the website -whatifwejustsaidwait.org that called for a pilot program to road test the translations, rather than force phrases like “consubstantial with the Father” into the mouths of Catholics. More than 23,000 people signed the website’s online petition in favor of delaying; others said he was being disloyal, trying to stand down the Church.
“I’m loyal, I love being a priest, I love my parishioners, I love the Church,” he told me. “But that doesn’t mean I can’t step out and ask questions and raise issues. The church has to have room for that; it always has.” At a time when the Catholic Church has taken to the trenches—battling clerical sex scandals, contraception, gay marriage, and as recently as April, the “radical feminism” of nuns who want to reform the church from within—it’s easy to forget that progress does happen. That there was an era when Catholics didn’t enter Protestant churches and the entire Mass was held in Latin. To hear Father Ryan speak his conscience, even if it doesn’t adhere to party lines, almost seems like a throwback.
Many Catholics, from the practicing to the lapsed, were shaped in some way by the church of their childhood, and Father Ryan is no different. Born a stone’s throw from St. James Cathedral in Columbus Hospital, formerly on the corner of Boren and Madison, he grew up in the 1940s in an Irish Catholic family “where questions weren’t asked much. We just accepted what we were given and loved the church and practiced our faith.” He attended St. Anne’s grade school on Queen Anne and St. Edward Seminary prep for high school, drawn to the fold by a sort-of “hero worship” of priests he’d known. But he truly came of age as a priest during his graduate studies in Rome in the 1960s, at the height of the Second Vatican Council. Pope John XXIII—another hero of Father Ryan’s—had gathered bishops and clergy from around the world to discuss the modern-day Catholic Church and how to “shake off the imperial dust.”
“I was catapulted into this world where there were huge questions being asked and advancements being made, and changes—even the notion of changing the liturgy from Latin to modern languages,” said Father Ryan. He spent his days attending lectures by notable theologians like Yves Congar, who spoke radically of interfaith cooperation, and his nights sitting around the dinner table debating the latest changes proposed during the day’s Vatican II session. “It was a fantastic time to be there and study theology. The winds of change were blowing, and it was refreshing and renewing and exciting.” Hard to believe that was 50 years ago. St. James Cathedral will celebrate the legacy of Vatican II throughout 2012 with a lecture series, capped off by the dedication of a shrine to the Vatican II reformer himself, Blessed Pope John XXIII.
When he returned to Washington from Rome, Father Ryan was assigned to St. Patrick’s parish in Tacoma, where he was taken under the wing of Rev. Thomas Pitsch. Father Pitsch was no wallflower: He took an active role in the political and social life of Tacoma, even served on the Human Rights Commission, and he encouraged Ryan to do the same. “It was a great eye-opener for me that the church could have a voice,” said Father Ryan, “not to tell people what to do, but to engage in a dialogue about where we’re going as a society, and what are the values, and what do we have to contribute.”
Father Ryan gestured toward his desk, a stately mahogany piece that looks difficult to move. “That’s his desk right there; he left it to me.” Perched on top, almost buried under stacks of papers and books, was a small wooden carving of Jesus as a shepherd with a lamb curled up at his feet. For Pitsch, he said, “People always came first. He knew the importance of laws and regulations, but he also knew that people always came first, and he instilled that deeply in me.
“I have a role as a teacher in the community and I try to carry that out faithfully,” Father Ryan said. “I think I need to speak on behalf of the people, and give them a voice…
“Even though I feel like we’re in some stormy, murky waters right now,” he added, glancing at his desk. “But I’m hopeful.”