How CMOs Can Solve the Next Set of Hospital Challenges
FOR IMMEDIATE RELEASE
Hospitals have systems in place that were designed to store, access and display digitized diagnostic images, but they are not enough for guaranteeing service levels, according to Ian Maynard, Chief Executive Officer, Real Time Medical. With organizations needing to guarantee responsiveness to urgent cases, automated diagnostic imaging workflow management is becoming essential, he added.
From a solution provider company at the upcoming marcus evans National Healthcare CMO/CMIO Spring 2013 in Atlanta, Georgia, March 14-15, Maynard talks about upcoming hospital requirements and how more efficient, automated workflow management can address some of the key issues.
Why are current hospital diagnostic systems inadequate?
Most are data-centric and designed to address the specific problem of data storage, access and display. With the challenges that hospitals are facing now, and the need to address managed service levels and improve clinical process efficiency, existing systems must be supplemented.
Currently, a typical worklist will display a long list of exams to be interpreted. If a radiologist assigned to a specific worklist or exam type receives multiple urgent cases, they may not get to each within the timeframe that the hospital aims for, or that is necessary for someone who has just had a stroke. It is just a list and a much more active approach to diagnostic service level management is needed.
How could they manage workflows better?
The workflows cannot be done manually. If there are 50 people spread across different campuses or hospitals, everyone’s work should be coordinated. If one clinician is caught up in a complex case, the next case should be re-distributed to another available clinician on the network, who also has the credentials to interpret the case.
How could your solution address these issues?
It responds to the dynamic changes in the environment and re-routes exams, depending on what comes through the door. Chief Medical Officers are concerned with the timeliness of reporting. They want to improve clinical process efficiency and guarantee responsiveness to urgent and non-urgent cases, so they have to balance the workloads.
The old systems were not designed to address the objectives that they must now deliver against. Several European countries are legislating a patient’s right to have all diagnostic results within a given period of time; in Denmark they are considering legislation a patient’s right to have all their diagnostic results within four hours of entering an emergency room. This includes results from the lab, radiology, cardiology, pathology, everything. They realized that people are dying from lack of responsive care.
Would this impact how hospitals are reimbursed for the care they deliver?
Improving productivity and workflow was recently cited as key to addressing operational deficiencies, driving patient-centric radiology and addressing declining reimbursements in a recent survey published 2013/01/02 in Clinical Innovation & Technology – Top Trends in Health Imaging: The Rise of Patient Centric Radiology. We were not surprised to find that a number of hospital objectives were related to the process challenges our solution addresses.
Also, there are times and certain disease states that require collaboration and communication to take place between different “ologies”, different disciplines. We can help organizations address patient responsiveness objectives, improved clinical productivity and efficiency, overhead reduction through automation, while simultaneously addressing quality assurance and peer review all within a single platform. A scope that normally requires purchase of three separate platforms.
Any final thoughts?
Current infrastructure and systems can and must be leveraged in order to solve the next set of challenges. There is no need for a rip and replace. A hospital’s existing investment can be leveraged to address these missing elements. Real Time Medical
Real Time Medical is a diagnostic imaging workflow innovation company. It develops vendor-neutral, context-aware workflow management software solutions. These solutions organize the reporting services in complex diagnostic imaging organizations more efficiently and productively. Real Time Medical’s platforms improve the timeliness, quality and accuracy of service delivery to patients while reducing manual case handling for healthcare organizations. These benefits result in system-wide, “ripple effect” savings to organizations.
Real Time Medical also operates the only nationwide, round-the-clock radiology service in Canada, employing the benefits of its DiaShareTM context-aware workflow management and QA software suite.