A pilot test of a smart charging system for plug-in electric vehicles, which was launched last week in Indianapolis, will help utilities develop pricing policies that encourage drivers to charge their cars when electricity demand is low, thereby lowering costs for drivers.
“This project is about taking EVs and the smart grid to the next level so the EV becomes an extension of the smart grid network, “ said Paul Mitchell, president and chief executive officer of Energy Systems Network, an Indianapolis-based nonprofit group focused on accelerating renewable energy and clean technology.
For 12 months, five Indianapolis-area drivers will be given one of Toyota’s new Prius plug-ins, each of which sport Toyota’s smart-charging technology. The cars will plug into a charging station, which will communicate electronically with the local utility—in this case Duke Energy, a cosponsor of the project.
Drivers program Toyota’s technology to tell it when they anticipate their next trip will be. The charging station, using data from Duke, then holds off on charging the car until the rates are lowest.
The Indianapolis pilot will be the first public test for Toyota’s new technology. And the effort will also serve as the first test-run of new standards developed by the Society of Automotive Engineers to govern two-way communication between plug-in EVs and utilities via charging stations.
Charging at times of low electricity demand, such as the middle of the night, reduces the need for utilities to fire up expensive peaker plants during times of high demand. A recent study in Texas found that EV owners tend to charge their cars immediately upon arriving home, at a time when their electricity use is already peaking from air conditioning and other appliances.
“If you can manage the existing grid so that it meets the need of fueling EVs without creating demand for more generation because you’re charging more intelligently, that’s real big step forward,” Mitchell said. It saves utilities–and ultimately ratepayers–money, in addition to cutting emissions.
“On the consumer side, the car is really able to go out and shop for the lowest price and most efficient energy for them,” Mitchell said.
ESN had previously worked with area utilities—both Duke and Indianapolis Power and Light—to deploy 100 public EV charging stations and 200 more inside people’s homes. This groundwork was important, Mitchell said. “Toyota needed to know that this place was an early adopter of EVs and that EVs had local support,” he said.
Toyota, Duke and ESN will use the smart charging equipment to gather all sorts of data, including when drivers charge their cars, for how long, and how much power they draw. Also, Duke will subject customers to rates that mimic demand-response pricing from other parts of the country, Mitchell said.
The data will be used to “to determine what kinds of incentive and disincentives are needed to get people to charge EVs in a harmonious way with the grid,” Mitchell said. The data will also reveal “what kind of interface is needed between the consumer and the grid—how to make it easy to use,” he added.
Although there will be just five cars involved in the pilot study, a small sample size, Duke, Toyota and ESN are trying to be as scientific as they can. “We’re trying to treat this as much as possible as a statistically significant sample,” Mitchell said. And they’re also interviewing drivers to gather qualitative information, he added.
The test could also be a step toward using EVs for electricity storage on the grid—a strategy known as “vehicle to grid,” Mitchell said.
In most areas, the grid lacks the storage capacity needed to use more renewable energy sources like wind and solar. Unlike a coal- or gas-fired power plant, these power sources produce electricity variably, so there’s a greater need for electricity storage on the grid.
The equipment in this study does not allow power flow from the EVs to the grid, but improving how cars communicate with the grid could accelerate true vehicle-to-grid development, he said.
“We need these community pilots to prove out that it’s even possible to do these things as a system,” Mitchell said. “In the end this is about making EV technology more attractive to consumers so they buy more plug-in vehicles.”