Experts in water, agriculture and conservation banded together at last week’s World Water Week in Stockholm to call for a major shift in global policies on agriculture and natural resource management, a change they said was urgently needed for future food and water security.
The call to action came on the back of a study released on during the conference by the United Nations Environment Programme (UNEP) and the Sri-Lanka headquartered International Water Management Institute (IWMI), which found that current agricultural trends are destroying the world’s natural resources, particularly its water supplies.
The study, An Ecosystem Services Approach to Water and Food Security, recommended urgent action to integrate greener farming methods and the conservation of natural areas to ensure food security and protect water sources.
Farming accounts for 70 to 90 per cent of water use in some areas, noted the authors of the study, who warned that in some of the world’s largest growing regions, including the ‘breadbaskets’ of northern China plains, Punjab in India and the Western United States, water was being used faster than sources could be replenished.
“Agriculture is both a major cause and victim of ecosystem degradation,” said IWMI’s scientific editor Eline Boelee in a statement.
She added that increasing agricultural production in a sustainable way i s a priority for future food security, but that “we need to take a more holistic ‘landscape’ approach.”
To achieve a ‘landscape’ approach, experts from IWMI and UNEP recommended ‘agroecosystems’, meaning systems whereby planning for food production and other land uses is integrated into a broader plan – one that ensures clean water, clean air and biodiversity for the long term.
Implementation will require combining the efforts of the agricultural sector and natural resource managers and advocates - two interest groups which have been traditionally separate and often in conflict, they noted.
Deputy director general for research at IWMI, David Molden, said, “The various political, research and community alliances now emerging are challenging the notion that we have to choose between food security and ecosystem health by making it clear that you can’t have one without the other.”
He noted that recent alliances between agricultural and conservation groups are blurring the lines between sustainable farming and natural resource protection. “For instance,,” he added.
The Consultative Group on International Agricultural Research (CGIAR) is host to IWMI and brings together research groups from around the world to find solutions to agricultural and food security issues.
Experts from UNEP and IWMI agree that agencies and organisations that manage agriculture, water resources, wildlife, forests and other natural resources often operate in isolation, and that much greater cooperation is needed for a sustainable approach to food production.
A separate study from IWMI, Wetlands, Agriculture and Poverty Reduction, found that efforts to preserve wetlands by excluding agriculture can actually increase the rate of destruction of the eco-system. IWMI’s Matthew McCartney, who co-authored the wetlands report, said, “Blanket prohibitions against cultivation do not always reduce ecosystem destruction and can make things worse.”
He cited an example of a farming ban on grassy wetlands in sub-Saharan Africa that led to grazing in the wetlands and deforestation upstream of the wetlands, both of which had greater negative environmental impacts than the earlier farming methods.
“What is needed is a balance: appropriate farming practices that support sustainable food production and protect ecosystems,” said Mr McCartney.
IWMI’s Mr Molden said it was essential to change the way modern societies view water and ecosystems and the way people interact with them.
One relationship society will need to understand is the inevitable link between growing enough food to feed communities and having a healthy water supply.
While a person consumes on average 2 to 4 litres of water per day for drinking, producing the food they eat requires 2,000 to 5,000 litres of water. With the world’s population expected to grow by 2.7 billion people by 2050, pressure on water resources will increase dramatically.
At the same time, the natural systems that store, filter and protect those water resources are increasingly degraded. China’s official agency reported recently that over the past 50 years, roughly 1,000 of the nation’s 3,000 natural lakes have disappeared. Other strains on water resources include rising pollution in waterways, plummeting levels in ground aquifers and lowered dam levels due to drought and damaged ecosystems.
“Managing water for food and ecosystems will bring great benefits, but there is no escaping the urgency of this situation. We are heading for disaster if we don’t change our practices from business as usual,” said Mr Molden.
World Water Week has been hosted annually by the Stockholm International Water Institute (SIWI) since 1991 and brings together experts and decision-makers from around the globe to find solutions to pressing water issues. This year’s theme was Water in an Urbanising World.